/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;

public class MatcherUtil {
    public static void assertThrows(ValidationJsonException ex, String field, String message) {
        Collection errors = CollectionUtils.emptyIfNull((Collection)((Collection)ex.getErrors().get(field)));
        Assertions.assertEquals((Object)(errors.isEmpty() ? field : message), (Object)errors.stream().map(e -> (Serializable)e.get("rule")).filter(message::equals).findAny().orElseGet(() -> errors.isEmpty() ? ex.getErrors().keySet().toString() : (Serializable)errors.stream().findFirst().map(e -> (Serializable)e.get("rule")).orElse(null)));
    }

    public static void assertThrows(ConstraintViolationException ex, String field, String message) {
        List<ConstraintViolation> errors = ex.getConstraintViolations().stream().filter(v -> field.equals(v.getPropertyPath().toString())).toList();
        ArrayList errorsS = new ArrayList();
        errors.forEach(v -> {
            errorsS.add((String)StringUtils.defaultIfBlank((CharSequence)ClassUtils.getShortClassName((String)ClassUtils.getPackageName((String)v.getMessageTemplate())), null));
            errorsS.add((String)StringUtils.defaultIfBlank((CharSequence)v.getMessageTemplate(), null));
        });
        List<String> errorsS2 = errorsS.stream().filter(Objects::nonNull).map(String::toLowerCase).toList();
        Assertions.assertEquals((Object)(errors.isEmpty() ? field : message.toLowerCase()), (Object)errorsS2.stream().filter(message::equalsIgnoreCase).findAny().orElseGet(() -> errors.isEmpty() ? ex.getConstraintViolations().stream().map(v -> v.getPropertyPath().toString()).collect(Collectors.toSet()).toString() : (String)errorsS2.stream().findFirst().orElse(null)));
    }
}

