/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.hibernate.collection.spi.PersistentBag;
import org.junit.jupiter.api.BeforeAll;
import org.ligoj.bootstrap.AbstractSecurityTest;
import org.ligoj.bootstrap.core.crypto.CryptoHelper;
import org.ligoj.bootstrap.core.csv.AbstractCsvManager;
import org.ligoj.bootstrap.core.dao.csv.CsvForJpa;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.core.io.ClassPathResource;

public abstract class AbstractJpaTest
extends AbstractSecurityTest {
    @Autowired
    protected CsvForJpa csvForJpa;
    @Autowired
    protected CryptoHelper cryptoHelper;
    @Autowired
    protected CacheManager cacheManager;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION, unitName="pu")
    protected EntityManager em;

    @BeforeAll
    static void init() {
        System.setProperty("app.crypto.file", "src/test/resources/security.key");
    }

    protected void clearAllCache() {
        this.cacheManager.getCacheNames().stream().map(arg_0 -> ((CacheManager)this.cacheManager).getCache(arg_0)).forEach(Cache::clear);
    }

    protected <T> List<T> persistEntities(Class<T> clazz, String resource) throws IOException {
        return this.persistEntities(clazz, resource, AbstractCsvManager.DEFAULT_ENCODING);
    }

    private <T> List<T> persistEntities(Class<T> clazz, String resource, Charset encoding) throws IOException {
        List list = this.csvForJpa.toJpa(clazz, (Reader)new InputStreamReader(new ClassPathResource(resource).getInputStream(), encoding), true, true);
        this.em.flush();
        this.em.clear();
        return list;
    }

    protected UriInfo persistEntities(String csvRoot, Class<?> ... entityModel) throws IOException {
        return this.persistEntities(csvRoot, entityModel, AbstractCsvManager.DEFAULT_ENCODING);
    }

    protected UriInfo persistEntities(String csvRoot, Class<?>[] entityModel, Charset encoding) throws IOException {
        this.csvForJpa.reset(csvRoot, (Class[])entityModel, encoding.name());
        return this.newUriInfo();
    }

    protected boolean isLazyInitialized(Collection<?> bag) {
        PersistentBag b;
        return bag instanceof PersistentBag && (b = (PersistentBag)bag).wasInitialized();
    }
}

