/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.curl;

import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.bootstrap.core.curl.CurlProcessor;
import org.ligoj.bootstrap.core.curl.CurlRequest;
import org.ligoj.bootstrap.core.curl.DefaultHttpResponseCallback;
import org.ligoj.bootstrap.core.curl.HttpResponseCallback;

public class AuthCurlProcessor
extends CurlProcessor {
    private final String username;
    private final String password;
    private static final Base64 BASE64_CODEC = new Base64(0);

    public AuthCurlProcessor(String username, String password, HttpResponseCallback callback) {
        super(callback);
        this.username = StringUtils.trimToNull((String)username);
        this.password = StringUtils.defaultString((String)password);
    }

    public AuthCurlProcessor(String username, String password) {
        this(username, password, new DefaultHttpResponseCallback());
    }

    @Override
    protected boolean process(CurlRequest request) {
        this.addAuthenticationHeader(request);
        return super.process(request);
    }

    protected void addAuthenticationHeader(CurlRequest request) {
        if (this.username != null) {
            String tmp = this.username + ":" + this.password;
            request.getHeaders().put("Authorization", "Basic " + BASE64_CODEC.encodeToString(tmp.getBytes(StandardCharsets.UTF_8)));
        }
    }
}

