/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.curl;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheResult;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class CurlCacheToken {
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    private final CurlCacheToken self = this;

    @CacheResult(cacheName="curl-tokens")
    public String getTokenCache(@CacheKey @NotNull String key, UnaryOperator<String> function, int retries, Supplier<? extends RuntimeException> exceptionSupplier) {
        return IntStream.range(0, retries).mapToObj(i -> (String)function.apply(key)).filter(Objects::nonNull).findFirst().orElseThrow(exceptionSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTokenCache(@NotNull Object synchronizeObject, @NotNull String key, UnaryOperator<String> function, int retries, Supplier<? extends RuntimeException> exceptionSupplier) {
        Object object = synchronizeObject;
        synchronized (object) {
            return this.self.getTokenCache(key, function, retries, exceptionSupplier);
        }
    }
}

