/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.curl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.ligoj.bootstrap.core.curl.CurlRequest;
import org.ligoj.bootstrap.core.curl.DefaultHttpResponseCallback;
import org.ligoj.bootstrap.core.curl.HttpResponseCallback;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurlProcessor
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(CurlProcessor.class);
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final DefaultHttpResponseCallback DEFAULT_CALLBACK = new DefaultHttpResponseCallback();
    private static final Map<String, Class<?>> SUPPORTED_METHOD = new HashMap();
    protected final CloseableHttpClient httpClient;
    protected final HttpClientBuilder clientBuilder;
    protected HttpResponseCallback callback;
    protected Function<CurlRequest, Boolean> replay;

    public static Registry<ConnectionSocketFactory> newSslContext() {
        return CurlProcessor.newSslContext("TLS");
    }

    protected static Registry<ConnectionSocketFactory> newSslContext(String protocol) {
        TrustManager[] allCerts = new TrustManager[]{new TrustedX509TrustManager()};
        try {
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(null, allCerts, new SecureRandom());
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            return RegistryBuilder.create().register("https", (Object)sslSocketFactory).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Unable to build a secured " + protocol + " registry", e);
        }
    }

    public static void validateAndClose(String url, String propertyName, String errorText) {
        try (CurlProcessor curlProcessor = new CurlProcessor();){
            curlProcessor.validate(url, propertyName, errorText);
        }
    }

    public CurlProcessor() {
        this(DEFAULT_CALLBACK);
    }

    public CurlProcessor(HttpResponseCallback callback) {
        this.callback = callback;
        this.clientBuilder = HttpClientBuilder.create();
        String proxyHost = System.getProperty(HTTPS_PROXY_HOST);
        HttpHost proxy = null;
        if (proxyHost != null) {
            proxy = new HttpHost(proxyHost, Integer.parseInt(System.getProperty(HTTPS_PROXY_PORT)));
        }
        BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager(CurlProcessor.newSslContext());
        this.clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        this.clientBuilder.setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("default").setRedirectsEnabled(false).setSocketTimeout(20000).setProxy(proxy).build());
        BasicCookieStore cookieStore = new BasicCookieStore();
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore((CookieStore)cookieStore);
        this.clientBuilder.setDefaultCookieStore((CookieStore)cookieStore);
        this.httpClient = this.clientBuilder.disableRedirectHandling().build();
    }

    private void addHeaders(CurlRequest request, String content, HttpRequestBase httpRequest) {
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            ((HttpEntityEnclosingRequest)httpRequest).setEntity((HttpEntity)new StringEntity(content, StandardCharsets.UTF_8));
            this.addSingleValuedHeader(request, httpRequest, "Content-Type", "application/x-www-form-urlencoded");
        }
        this.addSingleValuedHeader(request, httpRequest, "Accept-Charset", "utf-8");
        for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
            httpRequest.addHeader(header.getKey(), header.getValue());
        }
    }

    private void addSingleValuedHeader(CurlRequest request, HttpRequestBase httpRequest, String header, String defaultHeader) {
        if (request.getHeaders().keySet().stream().noneMatch(header::equalsIgnoreCase)) {
            httpRequest.addHeader(header, defaultHeader);
        }
    }

    protected boolean call(CurlRequest request, String url) throws Exception {
        final HttpRequestBase httpRequest = (HttpRequestBase)SUPPORTED_METHOD.get(request.getMethod()).getConstructor(String.class).newInstance(url);
        this.addHeaders(request, request.getContent(), httpRequest);
        if (request.getTimeout() != null) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    httpRequest.abort();
                }
            };
            new Timer(true).schedule(task, request.getTimeout().intValue());
        }
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequest);){
            request.setStatus(response.getStatusLine().getStatusCode());
            boolean bl = ((HttpResponseCallback)ObjectUtils.defaultIfNull((Object)request.getCallback(), (Object)this.callback)).onResponse(request, response);
            return bl;
        }
    }

    @Override
    public void close() {
        try {
            this.getHttpClient().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String get(String url, String ... headers) {
        CurlRequest curlRequest = new CurlRequest("GET", url, null, headers);
        curlRequest.setSaveResponse(true);
        this.process(curlRequest);
        return curlRequest.getResponse();
    }

    public boolean process(CurlRequest ... requests) {
        int counter = 0;
        for (CurlRequest request : requests) {
            request.counter = counter++;
            if (this.process(request)) continue;
            return false;
        }
        return true;
    }

    protected boolean process(CurlRequest request) {
        String url = request.getUrl();
        request.processor = this;
        try {
            boolean result = this.call(request, url);
            if (!result && this.replay != null) {
                result = this.replay.apply(request) != false && this.call(request, url);
            }
            return result;
        }
        catch (Exception e) {
            log.error("Request execution ' [{}] {} {}' failed : {}", new Object[]{request.getCounter(), request.getMethod(), url, e.getMessage()});
            return false;
        }
    }

    public boolean process(List<CurlRequest> requests) {
        return this.process(requests.toArray(new CurlRequest[0]));
    }

    public void validate(CurlRequest request, String propertyName, String errorText) {
        if (!this.process(request)) {
            throw new ValidationJsonException(propertyName, (Serializable)((Object)errorText), new Serializable[0]);
        }
    }

    public void validate(String url, String propertyName, String errorText) {
        this.validate(new CurlRequest("GET", url, null, new String[0]), propertyName, errorText);
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setCallback(HttpResponseCallback callback) {
        this.callback = callback;
    }

    public void setReplay(Function<CurlRequest, Boolean> replay) {
        this.replay = replay;
    }

    static {
        SUPPORTED_METHOD.put("GET", HttpGet.class);
        SUPPORTED_METHOD.put("POST", HttpPost.class);
        SUPPORTED_METHOD.put("PUT", HttpPut.class);
        SUPPORTED_METHOD.put("DELETE", HttpDelete.class);
    }

    public static class TrustedX509TrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

