/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.curl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.ligoj.bootstrap.core.curl.CurlProcessor;
import org.ligoj.bootstrap.core.curl.HttpResponseCallback;

public class CurlRequest {
    private boolean saveResponse;
    protected CurlProcessor processor;
    private String response;
    private int status;
    private final HttpResponseCallback callback;
    private final String method;
    private final String url;
    private final String content;
    private final Map<String, String> headers;
    protected int counter;
    protected Integer timeout;

    public CurlRequest(String method, String url, String content, HttpResponseCallback callback, String ... headers) {
        this.method = method;
        this.url = url;
        this.content = content;
        this.headers = new HashMap<String, String>();
        this.callback = callback;
        for (String header : headers) {
            String[] split = header.split(":");
            this.headers.put(split[0], split[1]);
        }
    }

    public CurlRequest(String method, String url, String content, String ... headers) {
        this(method, url, content, (HttpResponseCallback)null, headers);
    }

    public CurlRequest(String method, String url) {
        this(method, url, (String)null, (HttpResponseCallback)null, ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public boolean isSaveResponse() {
        return this.saveResponse;
    }

    public CurlProcessor getProcessor() {
        return this.processor;
    }

    public String getResponse() {
        return this.response;
    }

    public int getStatus() {
        return this.status;
    }

    public HttpResponseCallback getCallback() {
        return this.callback;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public String getContent() {
        return this.content;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setSaveResponse(boolean saveResponse) {
        this.saveResponse = saveResponse;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }
}

