/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.curl;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.ligoj.bootstrap.core.curl.CurlRequest;
import org.ligoj.bootstrap.core.curl.HttpResponseCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpResponseCallback
implements HttpResponseCallback {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpResponseCallback.class);

    @Override
    public boolean onResponse(CurlRequest request, CloseableHttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        log.info("{} {}", (Object)response.getStatusLine().getStatusCode(), (Object)request.getUrl());
        if (entity != null) {
            if (!this.acceptResponse(response)) {
                log.error(EntityUtils.toString((HttpEntity)entity));
                return false;
            }
            if (request.isSaveResponse()) {
                request.setResponse(EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8));
            }
            entity.getContent().close();
        }
        return true;
    }

    protected boolean acceptResponse(CloseableHttpResponse response) {
        return this.acceptStatus(response.getStatusLine().getStatusCode());
    }

    protected boolean acceptStatus(int status) {
        return status <= 204;
    }
}

