/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.dao;

import com.googlecode.gentyref.GenericTypeReflector;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.IdentifiableType;
import jodd.typeconverter.TypeConverterManager;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.query.criteria.internal.PathImplementor;
import org.hibernate.query.criteria.internal.path.SingularAttributeJoin;
import org.hibernate.query.criteria.internal.path.SingularAttributePath;

public abstract class AbstractSpecification {
    private static final TypeConverterManager CONVERTER = TypeConverterManager.get();
    public static final String DELIMITERS = "[_.]";
    private final AtomicInteger aliasCounter = new AtomicInteger();

    protected <U, T> Path<T> getOrmPath(Root<U> root, String path) {
        PathImplementor currentPath = (PathImplementor)root;
        for (String pathFragment : path.split(DELIMITERS)) {
            currentPath = this.getNextPath(pathFragment, (From)currentPath);
        }
        if (currentPath instanceof SingularAttributeJoin) {
            currentPath = this.getNextPath(((IdentifiableType)currentPath.getModel()).getId(Object.class).getName(), (From)currentPath);
        }
        return currentPath;
    }

    private <X> PathImplementor<X> getNextPath(String pathFragment, From<?, ?> from) {
        PathImplementor currentPath = (PathImplementor)from.get(pathFragment);
        this.fixAlias((Selection)from, this.aliasCounter);
        if (currentPath.getAttribute().getPersistentAttributeType() != Attribute.PersistentAttributeType.BASIC && (currentPath = this.getJoinPath(from, currentPath.getAttribute())) == null) {
            currentPath = this.fixAlias((Selection)from.join(pathFragment, JoinType.LEFT), this.aliasCounter);
        }
        return currentPath;
    }

    protected <U, T> PathImplementor<T> getJoinPath(From<?, U> from, Attribute<?, ?> attribute) {
        for (Join join : from.getJoins()) {
            if (!join.getAttribute().equals(attribute)) continue;
            return this.fixAlias((Selection<T>)join, this.aliasCounter);
        }
        return null;
    }

    private <T> PathImplementor<T> fixAlias(Selection<T> join, AtomicInteger integer) {
        if (join.getAlias() == null) {
            join.alias("_" + integer.incrementAndGet());
        }
        return (PathImplementor)join;
    }

    protected static <Y> Y toRawData(String data, Expression<Y> expression) {
        Class entity;
        Field field = (Field)((SingularAttributePath)expression).getAttribute().getJavaMember();
        Class expressionType = (Class)GenericTypeReflector.getExactFieldType((Field)field, (Type)(entity = ((SingularAttributePath)expression).getPathSource().getJavaType()));
        Object result = expressionType == Date.class ? new Date(Long.parseLong(data)) : (expressionType.isEnum() ? AbstractSpecification.toEnum(data, expression) : CONVERTER.convertType((Object)data, expressionType));
        return (Y)result;
    }

    private static <Y extends Enum<Y>> Enum<Y> toEnum(String data, Expression<Y> expression) {
        if (StringUtils.isNumeric((CharSequence)data)) {
            return ((Enum[])expression.getJavaType().getEnumConstants())[Integer.parseInt(data)];
        }
        Enum fromName = EnumUtils.getEnum((Class)expression.getJavaType(), (String)data);
        if (fromName == null) {
            fromName = Enum.valueOf(expression.getJavaType(), data.toUpperCase(Locale.ENGLISH));
        }
        return fromName;
    }
}

