/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.dao;

import java.util.Map;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.FetchParent;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class FetchHelper {
    public <T> void applyFetchedAssociations(Map<String, JoinType> fetchedAssociations, Root<T> root) {
        for (Map.Entry<String, JoinType> entry : fetchedAssociations.entrySet()) {
            JoinType joinType = entry.getValue();
            this.fetchAssociation(root, entry, joinType);
        }
    }

    private <T> void fetchAssociation(Root<T> root, Map.Entry<String, JoinType> entry, JoinType joinType) {
        String[] propertiesToFetch = StringUtils.split((String)entry.getKey(), (char)'.');
        Root<T> previouslyFetched = root;
        for (String property : propertiesToFetch) {
            previouslyFetched = this.getFetchedAssoc((FetchParent<?, ?>)previouslyFetched, joinType, property);
        }
    }

    private Fetch<?, ?> getFetchedAssoc(FetchParent<?, ?> parent, JoinType joinType, String propertyToFetch) {
        for (Fetch fetch : parent.getFetches()) {
            if (!fetch.getAttribute().getName().equals(propertyToFetch)) continue;
            return fetch;
        }
        return parent.fetch(propertyToFetch, joinType);
    }
}

