/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.dao;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.transaction.Transactional;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.collections4.MapUtils;
import org.ligoj.bootstrap.core.dao.CustomSpecification;
import org.ligoj.bootstrap.core.dao.DynamicSpecification;
import org.ligoj.bootstrap.core.dao.FetchHelper;
import org.ligoj.bootstrap.core.json.PaginationJson;
import org.ligoj.bootstrap.core.json.jqgrid.UiPageRequest;
import org.ligoj.bootstrap.core.json.jqgrid.UiSort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Repository
@Transactional(value=Transactional.TxType.MANDATORY)
public class PaginationDao {
    @PersistenceContext(unitName="pu")
    private EntityManager em;
    @Autowired
    private FetchHelper fetchHelper;
    @Autowired
    private PaginationJson paginationJson;

    public <T> Page<T> findAll(Class<T> type, UriInfo uriInfo, String ... mapping) {
        return this.findAll(type, uriInfo, Arrays.stream(mapping).map(s -> s.split(":")).collect(Collectors.toMap(s -> s[0], s -> s[((String[])s).length == 2 ? 1 : 0])));
    }

    public <T> Page<T> findAll(Class<T> entityType, UriInfo uriInfo, Map<String, String> mapping) {
        return this.findAll(entityType, uriInfo, mapping, null);
    }

    public <T> Page<T> findAll(Class<T> entityType, UriInfo uriInfo, Map<String, String> mapping, Map<String, JoinType> fetch) {
        return this.findAll(entityType, uriInfo, mapping, null, fetch);
    }

    public <T> Page<T> findAll(Class<T> entityType, UriInfo uriInfo, Map<String, String> mapping, Map<String, CustomSpecification> specifications, Map<String, JoinType> fetch) {
        return this.findAll(entityType, this.paginationJson.getUiPageRequest(uriInfo), mapping, specifications, fetch);
    }

    public <T> Page<T> findAll(Class<T> entityType, UiPageRequest uiPageRequest, Map<String, String> mapping, Map<String, CustomSpecification> specifications, Map<String, JoinType> fetch) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(entityType);
        Specification spec = this.newSpecification(uiPageRequest, mapping, specifications);
        Root root = query.from(entityType);
        if (!CollectionUtils.isEmpty(fetch)) {
            this.fetchHelper.applyFetchedAssociations(fetch, root);
        }
        this.applySpecificationToCriteria(root, spec, query);
        query.select((Selection)root);
        this.applyOrder(uiPageRequest, MapUtils.emptyIfNull(mapping), builder, query, root);
        return this.pagedResult(entityType, uiPageRequest, query, spec);
    }

    private <T> void applyOrder(UiPageRequest uiPageRequest, Map<String, String> mapping, CriteriaBuilder builder, CriteriaQuery<T> query, Root<T> root) {
        UiSort uiSort;
        String ormColumn;
        if (uiPageRequest.getUiSort() != null && (ormColumn = mapping.get((uiSort = uiPageRequest.getUiSort()).getColumn())) != null) {
            Sort sort = Sort.by((Sort.Direction)uiSort.getDirection(), (String[])new String[]{mapping.get(uiSort.getColumn())});
            query.orderBy(QueryUtils.toOrders((Sort)sort, root, (CriteriaBuilder)builder));
        }
    }

    private <T> Page<T> pagedResult(Class<T> entityType, UiPageRequest uiPageRequest, CriteriaQuery<T> query, Specification<T> spec) {
        TypedQuery query2 = this.em.createQuery(query);
        if (uiPageRequest.getPage() > 0 && uiPageRequest.getPageSize() > 0 || uiPageRequest.getUiSort() != null) {
            PageRequest pageable = PageRequest.of((int)Math.max(0, uiPageRequest.getPage() - 1), (int)Math.max(1, uiPageRequest.getPageSize()));
            return this.readPage(entityType, query2, (Pageable)pageable, spec);
        }
        return new PageImpl(query2.getResultList());
    }

    public <U> Specification<U> newSpecification(UiPageRequest uiPageRequest, Map<String, String> mapping, Map<String, CustomSpecification> specifications) {
        if (uiPageRequest.getUiFilter() == null || uiPageRequest.getUiFilter().getRules() == null || uiPageRequest.getUiFilter().getRules().isEmpty()) {
            return null;
        }
        return new DynamicSpecification(uiPageRequest.getUiFilter(), mapping, specifications);
    }

    private <T> Page<T> readPage(Class<T> entityType, TypedQuery<T> query, Pageable pageable, Specification<T> spec) {
        query.setFirstResult((int)pageable.getOffset());
        query.setMaxResults(pageable.getPageSize());
        Long total = (Long)this.getCountQuery(entityType, spec).getSingleResult();
        return new PageImpl(query.getResultList(), pageable, total.longValue());
    }

    private <T> TypedQuery<Long> getCountQuery(Class<T> entityType, Specification<T> spec) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root root = query.from(entityType);
        this.applySpecificationToCriteria(root, spec, query);
        query.select((Selection)builder.count((Expression)root));
        return this.em.createQuery(query);
    }

    private <S, T> Root<T> applySpecificationToCriteria(Root<T> root, Specification<T> spec, CriteriaQuery<S> query) {
        Assert.notNull(query, (String)"Query is requested");
        if (spec != null) {
            CriteriaBuilder builder = this.em.getCriteriaBuilder();
            Predicate predicate = spec.toPredicate(root, query, builder);
            query.where((Expression)predicate);
        }
        return root;
    }
}

