/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.dao;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.boot.archive.scan.internal.StandardScanner;
import org.hibernate.boot.archive.scan.spi.ScanEnvironment;
import org.hibernate.boot.archive.scan.spi.ScanOptions;
import org.hibernate.boot.archive.scan.spi.ScanParameters;
import org.hibernate.boot.archive.scan.spi.ScanResult;

public class ResourceScanner
extends StandardScanner {
    public static final String META_INF_ORM_XML = "META-INF/orm.xml";

    public ScanResult scan(ScanEnvironment environment, ScanOptions scanOptions, ScanParameters parameters) {
        try {
            LinkedHashSet urls = new LinkedHashSet(environment.getNonRootUrls());
            urls.addAll(Collections.list(this.getOrmUrls()).stream().map(this::getJarUrlSafe).collect(Collectors.toList()));
            urls.remove(environment.getRootUrl());
            environment.getNonRootUrls().clear();
            environment.getNonRootUrls().addAll(urls);
            return super.scan(environment, scanOptions, parameters);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read ORM Jars", e);
        }
    }

    private URL getJarUrlSafe(URL ormUrl) {
        try {
            return this.getJarUrl(ormUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Unable to read ORM file from jar", e);
        }
    }

    protected URL getJarUrl(URL ormUrl) throws MalformedURLException {
        String urlStr = ormUrl.toString();
        URL ormJarUrl = "jar".equals(ormUrl.getProtocol()) ? (StringUtils.countMatches((CharSequence)ormUrl.getPath(), (CharSequence)"!") > 1 ? new URL(StringUtils.substringBeforeLast((String)urlStr, (String)"!")) : new URL("file", ormUrl.getHost(), ormUrl.getPath().substring("file:".length(), ormUrl.getPath().indexOf(33)))) : new URL(urlStr.substring(0, urlStr.length() - META_INF_ORM_XML.length() - 1));
        return ormJarUrl;
    }

    protected Enumeration<URL> getOrmUrls() throws IOException {
        return Thread.currentThread().getContextClassLoader().getResources(META_INF_ORM_XML);
    }
}

