/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.dao;

import java.io.Serializable;
import javax.persistence.EntityManager;
import org.ligoj.bootstrap.core.dao.AfterJpaBeforeSpringDataListener;
import org.ligoj.bootstrap.core.dao.RestRepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class RestRepositoryFactoryBean<R extends JpaRepository<T, K>, T, K extends Serializable>
extends JpaRepositoryFactoryBean<R, T, K>
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(RestRepositoryFactoryBean.class);
    private ApplicationContext applicationContext;
    private static long lastListenerInvocation = 0L;

    public RestRepositoryFactoryBean(Class<? extends R> repositoryInterface) {
        super(repositoryInterface);
    }

    protected RepositoryFactorySupport createRepositoryFactory(EntityManager entityManager) {
        return new RestRepositoryFactory(entityManager);
    }

    public void afterPropertiesSet() {
        if (this.applicationContext.getStartupDate() != lastListenerInvocation) {
            log.info("Notify EMF is ready before parsing Spring-Data queries");
            lastListenerInvocation = this.applicationContext.getStartupDate();
            this.applicationContext.getBeansOfType(AfterJpaBeforeSpringDataListener.class).values().forEach(AfterJpaBeforeSpringDataListener::callback);
        }
        super.afterPropertiesSet();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private static class RestRepositoryFactory
    extends JpaRepositoryFactory {
        RestRepositoryFactory(EntityManager entityManager) {
            super(entityManager);
        }

        protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
            return RestRepositoryImpl.class;
        }
    }
}

