/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.bootstrap.core.json.PaginationJson;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.core.json.datatable.DataTableAttributes;
import org.ligoj.bootstrap.core.json.jqgrid.UiPageRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class InMemoryPagination {
    @Autowired
    protected PaginationJson paginationJson;

    public <T> Page<T> newPage(Collection<T> result, Pageable pageable) {
        int index;
        int start = Math.min(Math.max(pageable.getPageNumber() * pageable.getPageSize(), 0), result.size());
        int end = Math.min((pageable.getPageNumber() + 1) * pageable.getPageSize(), result.size());
        ArrayList<T> page = new ArrayList<T>(end - start);
        Iterator<T> iterator = result.iterator();
        for (index = 0; index < start; ++index) {
            iterator.next();
        }
        while (index < end) {
            page.add(iterator.next());
            ++index;
        }
        return new PageImpl(page, pageable, (long)result.size());
    }

    public <E, T> TableItem<T> applyPagination(UriInfo uriInfo, Collection<E> items, Function<E, T> transformer) {
        UiPageRequest uiPageRequest = this.paginationJson.getUiPageRequest(uriInfo);
        PageRequest pageRequest = PageRequest.of((int)(uiPageRequest.getPage() - 1), (int)uiPageRequest.getPageSize());
        return this.paginationJson.applyPagination(uriInfo, this.newPage(items, (Pageable)pageRequest), transformer);
    }

    public TableItem<String> getFilteredStringList(UriInfo uriInfo, Stream<String> items) {
        return this.applyPagination(uriInfo, items.filter(input -> StringUtils.containsIgnoreCase((CharSequence)input, (CharSequence)DataTableAttributes.getSearch(uriInfo))).collect(Collectors.toList()), Function.identity());
    }

    public TableItem<String> getFilteredStringList(UriInfo uriInfo, Collection<String> items) {
        return this.getFilteredStringList(uriInfo, items.stream());
    }
}

