/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.json;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.ObjectUtils;
import org.ligoj.bootstrap.core.json.ObjectMapperTrim;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.core.json.jqgrid.UiFilter;
import org.ligoj.bootstrap.core.json.jqgrid.UiPageRequest;
import org.ligoj.bootstrap.core.json.jqgrid.UiSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.JpaSort;
import org.springframework.stereotype.Component;

@Component
public class PaginationJson {
    private static final Logger log = LoggerFactory.getLogger(PaginationJson.class);
    public static final int DEFAULT_PAGE_SIZE = 10;
    protected static final Map<String, String> IDENTITY_MAPPING = Collections.singletonMap("*", "*");

    public UiPageRequest getUiPageRequest(UriInfo uriInfo) {
        return this.getUiPageRequest(uriInfo, IDENTITY_MAPPING);
    }

    public UiPageRequest getUiPageRequest(UriInfo uriInfo, Map<String, String> ormMapping) {
        MultivaluedMap parameters = uriInfo.getQueryParameters();
        UiPageRequest request = new UiPageRequest();
        request.setUiFilter(this.buildFilter((String)parameters.getFirst((Object)"filters")));
        request.setUiSort(this.buildSort(this.getOrmColumn(ormMapping, this.getSortColumn((MultivaluedMap<String, String>)parameters)), this.getSortDirection((MultivaluedMap<String, String>)parameters)));
        request.setPage((Integer)ObjectUtils.defaultIfNull((Object)this.getPage((MultivaluedMap<String, String>)parameters), (Object)1));
        request.setPageSize(this.getPageLength((MultivaluedMap<String, String>)parameters));
        return request;
    }

    private UiSort buildSort(String sortColumn, String sortDirection) {
        if (sortColumn == null) {
            return null;
        }
        UiSort sort = new UiSort();
        sort.setColumn(sortColumn);
        sort.setDirection(Optional.ofNullable(sortDirection).map(d -> Sort.Direction.valueOf((String)d.toUpperCase(Locale.ENGLISH))).orElse(Sort.Direction.ASC));
        return sort;
    }

    public PageRequest getPageRequest(UriInfo uriInfo, Map<String, String> ormMapping) {
        return this.getPageRequest(uriInfo, ormMapping, null);
    }

    public PageRequest getPageRequest(UriInfo uriInfo, Map<String, String> ormMapping, Collection<String> caseSensitiveColumns) {
        if (uriInfo == null) {
            return PageRequest.of((int)0, (int)10);
        }
        MultivaluedMap parameters = uriInfo.getQueryParameters();
        int pageLength = this.getPageLength((MultivaluedMap<String, String>)parameters);
        int firstPage = Optional.ofNullable(this.getPage((MultivaluedMap<String, String>)parameters)).map(p -> p - 1).orElse(this.getStart((MultivaluedMap<String, String>)parameters) / pageLength);
        return this.buildOrderedPageRequest(ormMapping, (MultivaluedMap<String, String>)parameters, pageLength, firstPage, caseSensitiveColumns);
    }

    public int getPageLength(MultivaluedMap<String, String> parameters) {
        return Optional.ofNullable((String)parameters.getFirst((Object)"rows")).map(Integer::parseInt).orElse(Optional.ofNullable((String)parameters.getFirst((Object)"length")).map(Integer::parseInt).orElse(10));
    }

    public Integer getPage(MultivaluedMap<String, String> parameters) {
        return Optional.ofNullable((String)parameters.getFirst((Object)"page")).map(Integer::parseInt).map(p -> Math.max(1, p)).orElse(null);
    }

    private int getStart(MultivaluedMap<String, String> parameters) {
        return Optional.ofNullable((String)parameters.getFirst((Object)"start")).map(Integer::parseInt).map(s -> Math.max(0, s)).orElse(0);
    }

    private String getSortColumn(MultivaluedMap<String, String> parameters) {
        return Optional.ofNullable((String)parameters.getFirst((Object)"sidx")).orElse(Optional.ofNullable((String)parameters.getFirst((Object)"order[0][column]")).map(i -> (String)parameters.getFirst((Object)String.format("columns[%s][data]", i))).orElse(null));
    }

    private String getSortDirection(MultivaluedMap<String, String> parameters) {
        return Optional.ofNullable((String)parameters.getFirst((Object)"sord")).orElse((String)ObjectUtils.defaultIfNull((Object)((String)parameters.getFirst((Object)"order[0][dir]")), (Object)"ASC"));
    }

    private PageRequest buildOrderedPageRequest(Map<String, String> ormMapping, MultivaluedMap<String, String> parameters, int pageLength, int firstPage, Collection<String> caseSensitiveColumns) {
        return Optional.ofNullable(this.getSortColumn(parameters)).map(c -> this.newSortedPageRequest(ormMapping, parameters, pageLength, firstPage, (String)c, caseSensitiveColumns)).orElse(PageRequest.of((int)firstPage, (int)pageLength));
    }

    @NotNull
    private PageRequest newSortedPageRequest(Map<String, String> ormMapping, MultivaluedMap<String, String> parameters, int pageLength, int firstPage, String column, Collection<String> caseSensitiveColumns) {
        PageRequest pageRequest;
        String direction = this.getSortDirection(parameters);
        String ormProperty = this.getOrmColumn(ormMapping, column);
        if (ormProperty == null) {
            pageRequest = PageRequest.of((int)firstPage, (int)pageLength);
        } else {
            Object sort = !(caseSensitiveColumns != null && caseSensitiveColumns.contains(column) || ormProperty.indexOf(40) != -1) ? (ormProperty.indexOf(46) == -1 ? Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.valueOf((String)direction.toUpperCase(Locale.ENGLISH)), ormProperty).ignoreCase()}) : JpaSort.unsafe((Sort.Direction)Sort.Direction.valueOf((String)direction.toUpperCase(Locale.ENGLISH)), (String[])new String[]{"UPPER(" + ormProperty + ")"})) : JpaSort.unsafe((Sort.Direction)Sort.Direction.valueOf((String)direction.toUpperCase(Locale.ENGLISH)), (String[])new String[]{ormProperty});
            pageRequest = PageRequest.of((int)firstPage, (int)pageLength, (Sort)sort);
        }
        return pageRequest;
    }

    private String getOrmColumn(Map<String, String> ormMapping, String key) {
        return Optional.ofNullable(ormMapping).map(m -> m.getOrDefault(key, m.containsKey("*") ? key : null)).orElse(null);
    }

    public <T, E> TableItem<T> applyPagination(UriInfo uriInfo, Page<E> items, Function<E, T> converter) {
        TableItem result = new TableItem();
        result.setData(items.getContent().stream().map(converter).collect(Collectors.toList()));
        result.setRecordsFiltered(items.getTotalElements());
        result.setRecordsTotal(items.getTotalElements());
        result.setDraw(uriInfo == null ? null : (String)uriInfo.getQueryParameters().getFirst((Object)"draw"));
        return result;
    }

    public UiFilter buildFilter(String jsonString) {
        if (jsonString != null) {
            ObjectMapperTrim mapper = new ObjectMapperTrim();
            try {
                return (UiFilter)mapper.readValue(jsonString, UiFilter.class);
            }
            catch (IOException e) {
                log.error(String.format("Unable to parse JSon data :%s", jsonString), (Throwable)e);
            }
        }
        return new UiFilter();
    }
}

