/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.ligoj.bootstrap.core.resource.AbstractParameteredException;
import org.ligoj.bootstrap.core.resource.ServerError;
import org.ligoj.bootstrap.core.resource.TechnicalException;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMapper {
    @Autowired
    protected JacksonJsonProvider jacksonJsonProvider;

    protected Response toResponse(Response.StatusType status, String errorKey, Throwable ex) {
        ServerError serverError = new ServerError();
        serverError.setCode(errorKey);
        if (ex != null) {
            serverError.setThrowable(ex);
        }
        if (ex instanceof AbstractParameteredException && ((AbstractParameteredException)ex).getParameters().length > 0) {
            serverError.setParameters(((AbstractParameteredException)ex).getParameters());
        }
        return this.toResponse(status, serverError);
    }

    protected Response toResponse(Response.StatusType status, Object object) {
        return Response.status((Response.StatusType)status).type(MediaType.APPLICATION_JSON_TYPE).entity(this.toEntity(object)).build();
    }

    protected Object toEntity(Object object) {
        try {
            return this.jacksonJsonProvider.locateMapper(object.getClass(), MediaType.APPLICATION_JSON_TYPE).writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new TechnicalException("Unable to build a JSON string from a server error", (Throwable)e, new Object[0]);
        }
    }
}

