/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.resource.mapper;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.ligoj.bootstrap.core.resource.AbstractMapper;
import org.ligoj.bootstrap.core.resource.ServerError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;

@Provider
public class DataIntegrityViolationExceptionMapper
extends AbstractMapper
implements ExceptionMapper<DataIntegrityViolationException> {
    private static final Logger log = LoggerFactory.getLogger(DataIntegrityViolationExceptionMapper.class);
    private static final Pattern PATTERN_FOREIGN_KEY = Pattern.compile("`(\\w+)`, CONSTRAINT `.*` FOREIGN KEY \\(`(\\w+)`\\)");
    private static final Pattern PATTERN_UNICITY = Pattern.compile("Duplicate entry '([^']+)' for key '([^']+)'");

    public Response toResponse(DataIntegrityViolationException exception) {
        String code;
        log.error("DataIntegrityViolationException exception", (Throwable)exception);
        Throwable root = ExceptionUtils.getRootCause((Throwable)exception);
        Matcher matcher = PATTERN_FOREIGN_KEY.matcher(StringUtils.trimToEmpty((String)root.getMessage()));
        if (matcher.find()) {
            code = "foreign";
        } else {
            matcher = PATTERN_UNICITY.matcher(root.getMessage());
            if (matcher.find()) {
                code = "unicity";
            } else {
                code = "unknown";
                matcher = null;
            }
        }
        return this.toResponse((Response.StatusType)Response.Status.PRECONDITION_FAILED, this.newServerError((Throwable)exception, matcher, code));
    }

    private ServerError newServerError(Throwable exception, Matcher matcher, String code) {
        ServerError serverError = new ServerError();
        serverError.setCode("integrity-" + code);
        serverError.setThrowable(exception.getCause());
        if (matcher != null) {
            serverError.setMessage(matcher.group(1) + "/" + matcher.group(2));
        }
        return serverError;
    }
}

