/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.resource.mapper;

import javax.naming.CommunicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.ligoj.bootstrap.core.resource.AbstractMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class FailSafeExceptionMapper
extends AbstractMapper
implements ExceptionMapper<Throwable> {
    private static final Logger log = LoggerFactory.getLogger(FailSafeExceptionMapper.class);

    public Response toResponse(Throwable exception) {
        if (exception.getCause() instanceof CommunicationException) {
            log.error("LDAP exception", exception);
            return this.toResponse((Response.StatusType)Response.Status.SERVICE_UNAVAILABLE, "ldap-down", exception.getCause());
        }
        log.error("Non managed error", exception);
        return this.toResponse((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "internal", null);
    }
}

