/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.resource.mapper;

import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.ligoj.bootstrap.core.resource.AbstractMapper;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionSystemException;

@Provider
public class TransactionSystemExceptionMapper
extends AbstractMapper
implements ExceptionMapper<TransactionSystemException> {
    private static final Logger log = LoggerFactory.getLogger(TransactionSystemExceptionMapper.class);

    public Response toResponse(TransactionSystemException ex) {
        if (ExceptionUtils.getRootCause((Throwable)ex) instanceof ConstraintViolationException) {
            return this.toResponse((Response.StatusType)Response.Status.BAD_REQUEST, new ValidationJsonException((ConstraintViolationException)ExceptionUtils.getRootCause((Throwable)ex)));
        }
        log.error("Technical exception", (Throwable)ex);
        return this.toResponse((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "technical", (Throwable)ex);
    }
}

