/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.bootstrap.core.resource.mapper.AccessDeniedExceptionMapper;
import org.ligoj.bootstrap.model.system.SystemAuthorization;
import org.ligoj.bootstrap.resource.system.security.AuthorizationResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class AuthorizingFilter
extends GenericFilterBean {
    @Autowired
    private AuthorizationResource authorizationResource;
    @Autowired
    private AccessDeniedExceptionMapper accessDeniedHelper;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpMethod method;
        String fullRequest;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        Collection authorities = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
        if (!authorities.contains(new SimpleGrantedAuthority("ROLE_ANONYMOUS")) && !this.isAuthorized(authorities, fullRequest = this.getFullRequest(httpRequest), method = HttpMethod.valueOf((String)StringUtils.upperCase((String)httpRequest.getMethod(), (Locale)Locale.ENGLISH)))) {
            this.updateForbiddenAccess((HttpServletResponse)response);
            return;
        }
        chain.doFilter(request, response);
    }

    private void updateForbiddenAccess(HttpServletResponse response) throws IOException {
        Response response2 = this.accessDeniedHelper.toResponse(new AccessDeniedException(""));
        response.setStatus(response2.getStatus());
        response.setContentType(response2.getMediaType().toString());
        response.getOutputStream().write(((String)response2.getEntity()).getBytes(StandardCharsets.UTF_8));
    }

    private String getFullRequest(HttpServletRequest httpRequest) {
        return StringUtils.removeStart((String)httpRequest.getRequestURI().substring(this.getServletContext().getContextPath().length()), (String)"/");
    }

    private boolean isAuthorized(Collection<? extends GrantedAuthority> authorities, String request, HttpMethod method) {
        Map<String, Map<HttpMethod, List<Pattern>>> authorizationsCache = this.authorizationResource.getAuthorizations().get(SystemAuthorization.AuthorizationType.API);
        if (authorizationsCache != null) {
            for (GrantedAuthority grantedAuthority : authorities) {
                Map<HttpMethod, List<Pattern>> authorizations = authorizationsCache.get(grantedAuthority.getAuthority());
                if (authorizations == null || !this.match((Collection<Pattern>)authorizations.get(method), request)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean match(Collection<Pattern> patterns, String toMatch) {
        if (patterns != null) {
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(toMatch).find()) continue;
                return true;
            }
        }
        return false;
    }
}

