/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component
public class ErrorToJsonFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(ErrorToJsonFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException {
        try {
            chain.doFilter(request, response);
        }
        catch (Exception exception) {
            log.error("High level error", (Throwable)exception);
            HttpServletResponse response3 = (HttpServletResponse)response;
            response3.setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            response3.setContentType(MediaType.APPLICATION_JSON_TYPE.toString());
            response3.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response3.getOutputStream().write("{\"code\":\"internal\"}".getBytes(StandardCharsets.UTF_8));
            response3.flushBuffer();
        }
    }
}

