/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.dao.system.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.ligoj.bootstrap.dao.system.BenchResult;
import org.ligoj.bootstrap.dao.system.ISystemPerformanceJpaDao;
import org.ligoj.bootstrap.model.system.SystemBench;
import org.springframework.stereotype.Repository;

@Repository
@Transactional(value=Transactional.TxType.REQUIRES_NEW)
public class JpaBenchDao
implements ISystemPerformanceJpaDao {
    @PersistenceContext(unitName="pu")
    private EntityManager em;

    @Override
    public BenchResult initialize(int nbEntries, byte[] lobData) {
        this.em.createQuery("DELETE FROM " + SystemBench.class.getName()).executeUpdate();
        int i = nbEntries;
        while (i-- > 0) {
            SystemBench perf = new SystemBench();
            perf.setPrfBool(Boolean.valueOf(i % 2 == 0));
            perf.setPrfChar("Performance JPA2 " + i);
            perf.setPicture(lobData);
            this.em.persist((Object)perf);
            this.em.flush();
            this.em.clear();
        }
        BenchResult result = new BenchResult();
        result.setEntries(nbEntries);
        return result;
    }

    @Override
    public byte[] getLastAvailableLob() {
        List resultList = this.em.createQuery("FROM " + SystemBench.class.getName() + " WHERE picture != null ORDER BY id DESC", SystemBench.class).setMaxResults(1).getResultList();
        if (resultList.isEmpty()) {
            return new byte[0];
        }
        return ((SystemBench)resultList.get(0)).getPicture();
    }

    @Override
    public BenchResult benchRead() {
        List<Integer> entries = this.getEntries();
        for (int prfId : entries) {
            this.em.find(SystemBench.class, (Object)prfId);
            this.em.clear();
        }
        BenchResult benchResult = new BenchResult();
        benchResult.setEntries(entries.size());
        return benchResult;
    }

    @Override
    public BenchResult benchUpdate() {
        List<Integer> entries = this.getEntries();
        for (int prfId : entries) {
            this.em.createQuery("UPDATE " + SystemBench.class.getName() + " SET prfBool = false WHERE id = :prfId").setParameter("prfId", (Object)prfId).executeUpdate();
        }
        BenchResult benchResult = new BenchResult();
        benchResult.setEntries(entries.size());
        return benchResult;
    }

    private List<Integer> getEntries() {
        return this.em.createQuery("SELECT id FROM " + SystemBench.class.getName(), Integer.class).getResultList();
    }

    @Override
    public BenchResult benchDelete() {
        List<Integer> entries = this.getEntries();
        for (int prfId : entries) {
            this.em.createQuery("DELETE " + SystemBench.class.getName() + " WHERE id = :prfId").setParameter("prfId", (Object)prfId).executeUpdate();
        }
        BenchResult benchResult = new BenchResult();
        benchResult.setEntries(entries.size());
        return benchResult;
    }

    @Override
    public BenchResult benchReadAll() {
        List entries = this.em.createQuery("FROM " + SystemBench.class.getName(), SystemBench.class).getResultList();
        BenchResult benchResult = new BenchResult();
        benchResult.setEntries(entries.size());
        return benchResult;
    }
}

