/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system;

import java.io.File;
import java.util.Arrays;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.ligoj.bootstrap.core.DateUtils;
import org.ligoj.bootstrap.resource.system.CpuVo;
import org.ligoj.bootstrap.resource.system.DateVo;
import org.ligoj.bootstrap.resource.system.FileVo;
import org.ligoj.bootstrap.resource.system.MemoryVo;
import org.ligoj.bootstrap.resource.system.SystemVo;
import org.springframework.stereotype.Service;

@Service
@Path(value="/system")
@Produces(value={"application/json"})
public class SystemResource {
    @GET
    public SystemVo getConfiguration() {
        SystemVo settings = new SystemVo();
        DateVo dateVo = new DateVo();
        settings.setDate(dateVo);
        dateVo.setDate(DateUtils.newCalendar().getTime());
        dateVo.setDefaultTimeZone(TimeZone.getDefault().getID());
        dateVo.setTimeZone(DateUtils.getApplicationTimeZone().getID());
        dateVo.setOriginalDefaultTimeZone(DateUtils.ORIGINAL_DEFAULT_TIMEZONE.getID());
        MemoryVo memoryVo = new MemoryVo();
        settings.setMemory(memoryVo);
        memoryVo.setFreeMemory(Runtime.getRuntime().freeMemory());
        memoryVo.setMaxMemory(Runtime.getRuntime().maxMemory());
        memoryVo.setTotalMemory(Runtime.getRuntime().totalMemory());
        CpuVo cpuVo = new CpuVo();
        settings.setCpu(cpuVo);
        cpuVo.setTotal(Runtime.getRuntime().availableProcessors());
        settings.setFiles(Arrays.stream(File.listRoots()).map(root -> {
            FileVo fileVo = new FileVo();
            fileVo.setAbsolutePath(root.getAbsolutePath());
            fileVo.setTotalSpace(root.getTotalSpace());
            fileVo.setFreeSpace(root.getFreeSpace());
            fileVo.setUsableSpace(root.getUsableSpace());
            return fileVo;
        }).collect(Collectors.toList()));
        return settings;
    }

    @PUT
    @Path(value="timezone/application")
    public void setApplicationTimeZone(String id) {
        DateUtils.setApplicationTimeZone((TimeZone)TimeZone.getTimeZone(id));
    }

    @PUT
    @Path(value="timezone/default")
    public void setTimeZone(String id) {
        TimeZone.setDefault(TimeZone.getTimeZone(id));
    }
}

