/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.cache;

import com.hazelcast.cache.HazelcastCacheManager;
import com.hazelcast.cache.impl.CacheProxy;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.Member;
import com.hazelcast.internal.cluster.ClusterService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import javax.transaction.Transactional;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.ligoj.bootstrap.resource.system.cache.CacheCluster;
import org.ligoj.bootstrap.resource.system.cache.CacheNode;
import org.ligoj.bootstrap.resource.system.cache.CacheStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.jcache.JCacheCacheManager;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.stereotype.Service;

@Path(value="/system/cache")
@Service
@Transactional
@Produces(value={"application/json"})
public class CacheResource
implements ApplicationListener<ContextClosedEvent> {
    private static final Logger log = LoggerFactory.getLogger(CacheResource.class);
    @Autowired
    protected CacheManager cacheManager;

    @GET
    public List<CacheStatistics> getCaches() {
        ArrayList<CacheStatistics> result = new ArrayList<CacheStatistics>();
        for (String cache : this.cacheManager.getCacheNames()) {
            result.add(this.getCache(cache));
        }
        return result;
    }

    @GET
    @Path(value="{name:[\\w\\-]+}")
    public CacheStatistics getCache(@PathParam(value="name") String name) {
        CacheStatistics result = new CacheStatistics();
        CacheProxy cache = (CacheProxy)this.getCacheExpected(name).getNativeCache();
        CacheNode node = this.newCacheNode(cache.getNodeEngine().getLocalMember());
        node.setCluster(this.newCacheCluster(cache.getNodeEngine().getClusterService()));
        result.setId(name);
        result.setNode(node);
        this.setStatistics(result, cache.getLocalCacheStatistics());
        return result;
    }

    private Cache getCacheExpected(String name) {
        return Optional.ofNullable(this.cacheManager.getCache(name)).orElseThrow(() -> new EntityNotFoundException(name));
    }

    protected void setStatistics(CacheStatistics result, com.hazelcast.cache.CacheStatistics statistics) {
        result.setSize(statistics.getOwnedEntryCount());
        if (CacheResource.isStatisticEnabled()) {
            result.setMissPercentage(Float.valueOf(statistics.getCacheMissPercentage()));
            result.setMissCount(statistics.getCacheMisses());
            result.setHitPercentage(Float.valueOf(statistics.getCacheHitPercentage()));
            result.setHitCount(statistics.getCacheHits());
            result.setAverageGetTime(Float.valueOf(statistics.getAverageGetTime()));
        }
    }

    private CacheNode newCacheNode(Member member) {
        CacheNode node = new CacheNode();
        node.setAddress(Objects.toString(member.getAddress()));
        node.setId(member.getUuid());
        node.setVersion(Objects.toString(member.getVersion()));
        return node;
    }

    private CacheCluster newCacheCluster(ClusterService clusterService) {
        CacheCluster cluster = new CacheCluster();
        cluster.setId(clusterService.getClusterId());
        cluster.setState(clusterService.getClusterState().toString());
        cluster.setMembers(clusterService.getMembers().stream().map(this::newCacheNode).collect(Collectors.toList()));
        return cluster;
    }

    @POST
    @DELETE
    @Path(value="{name:[\\w\\-]+}")
    public void invalidate(@PathParam(value="name") String name) {
        this.getCacheExpected(name).clear();
    }

    @DELETE
    public void invalidate() {
        this.cacheManager.getCacheNames().stream().map(arg_0 -> ((CacheManager)this.cacheManager).getCache(arg_0)).forEach(Cache::clear);
    }

    public static boolean isStatisticEnabled() {
        return System.getProperty("java.security.policy") != null;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        log.info("Stopping context detected, shutdown the Hazelcast instance");
        HazelcastCacheManager manager = (HazelcastCacheManager)((JCacheCacheManager)this.cacheManager).getCacheManager();
        try {
            manager.getHazelcastInstance().getLifecycleService().terminate();
        }
        catch (HazelcastInstanceNotActiveException he) {
            log.info("Hazelcast node was already terminated: {}", (Object)he.getMessage());
        }
    }
}

