/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.cache;

import com.hazelcast.cache.HazelcastCacheManager;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import java.net.URI;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.spi.CachingProvider;
import org.ligoj.bootstrap.resource.system.cache.CacheManagerAware;
import org.ligoj.bootstrap.resource.system.cache.CacheResource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class MergedHazelCastManagerFactoryBean
implements FactoryBean<CacheManager>,
InitializingBean,
DisposableBean {
    protected CacheManager cacheManager;
    @Autowired
    protected ApplicationContext context;

    public void afterPropertiesSet() {
        CachingProvider provider = Caching.getCachingProvider();
        HazelcastCacheManager manager = (HazelcastCacheManager)provider.getCacheManager(URI.create("bootstrap-cache-manager"), null);
        this.context.getBeansOfType(CacheManagerAware.class).forEach((n, a) -> a.onCreate(manager, this::newCacheConfig));
        this.cacheManager = manager;
    }

    protected void postConfigure(CacheConfig<?, ?> mapConfig) {
        if (CacheResource.isStatisticEnabled()) {
            mapConfig.setStatisticsEnabled(true);
        }
    }

    private CacheConfig<?, ?> newCacheConfig(String name) {
        CacheConfig config = new CacheConfig(name);
        config.setEvictionConfig(new EvictionConfig().setEvictionPolicy(EvictionPolicy.LRU).setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT));
        config.setExpiryPolicyFactory(AccessedExpiryPolicy.factoryOf((Duration)Duration.ETERNAL));
        this.postConfigure(config);
        return config;
    }

    public CacheManager getObject() {
        return this.cacheManager;
    }

    public Class<? extends CacheManager> getObjectType() {
        return this.cacheManager == null ? CacheManager.class : this.cacheManager.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.cacheManager.close();
    }
}

