/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.CacheValue;
import javax.transaction.Transactional;
import javax.validation.constraints.NotBlank;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.ligoj.bootstrap.core.AuditedBean;
import org.ligoj.bootstrap.core.crypto.CryptoHelper;
import org.ligoj.bootstrap.core.model.Auditable;
import org.ligoj.bootstrap.dao.system.SystemConfigurationRepository;
import org.ligoj.bootstrap.model.system.SystemConfiguration;
import org.ligoj.bootstrap.resource.system.configuration.ConfigurationEditionVo;
import org.ligoj.bootstrap.resource.system.configuration.ConfigurationVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.stereotype.Service;

@Service
@Path(value="/system/configuration")
@Transactional
@Produces(value={"application/json"})
public class ConfigurationResource {
    @Autowired
    private CryptoHelper cryptoHelper;
    @Autowired
    private SystemConfigurationRepository repository;
    @Autowired
    private ConfigurationResource self;
    @Autowired
    protected ConfigurableEnvironment env;

    public int get(String key, int defaultValue) {
        return NumberUtils.toInt((String)this.self.get(key), (int)defaultValue);
    }

    public String get(String key, String defaultValue) {
        return (String)ObjectUtils.defaultIfNull((Object)this.self.get(key), (Object)defaultValue);
    }

    @CacheResult(cacheName="configuration")
    public String get(@CacheKey String name) {
        return Optional.ofNullable(this.getRaw(name)).map(arg_0 -> ((CryptoHelper)this.cryptoHelper).decryptAsNeeded(arg_0)).orElse(null);
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"text/plain"})
    public String getUnSecuredOnly(@CacheKey @PathParam(value="name") String name) {
        return this.cryptoHelper.decryptedOnly(this.getRaw(name));
    }

    private String getRaw(String name) {
        String value = StringUtils.trimToNull((String)this.env.getProperty(name));
        if (value == null) {
            value = Optional.ofNullable((SystemConfiguration)this.repository.findByName(name)).map(SystemConfiguration::getValue).map(StringUtils::trimToNull).orElse(null);
        }
        return value;
    }

    @GET
    public List<ConfigurationVo> findAll() {
        TreeMap result = new TreeMap();
        this.env.getPropertySources().forEach(source -> {
            if (source instanceof EnumerablePropertySource) {
                EnumerablePropertySource eSource = (EnumerablePropertySource)source;
                Arrays.stream(eSource.getPropertyNames()).map(v -> {
                    ConfigurationVo vo = new ConfigurationVo();
                    vo.setName((String)v);
                    vo.setSource(eSource.getName());
                    this.updateVo(String.valueOf(eSource.getProperty(v)), vo);
                    return vo;
                }).forEach(vo -> result.put(vo.getName(), vo));
            }
        });
        this.repository.findAll().forEach(c -> {
            if (result.containsKey(c.getName())) {
                ((ConfigurationVo)((Object)((Object)result.get(c.getName())))).setOverride(true);
            } else {
                ConfigurationVo vo = new ConfigurationVo();
                AuditedBean.copyAuditData((Auditable)c, (Auditable)vo);
                vo.setPersisted(true);
                vo.setName(c.getName());
                vo.setSource("database");
                this.updateVo(c.getValue(), vo);
                result.put(c.getName(), vo);
            }
        });
        return new ArrayList<ConfigurationVo>(result.values());
    }

    private void updateVo(String value, ConfigurationVo vo) {
        if (value.equals(this.cryptoHelper.decryptAsNeeded(value))) {
            vo.setValue(value);
        } else {
            vo.setSecured(true);
        }
    }

    @POST
    @PUT
    @Path(value="{name}")
    @CachePut(cacheName="configuration")
    public void put(@CacheKey @PathParam(value="name") String name, @CacheValue @NotBlank String value) {
        this.put(name, value, false);
    }

    @POST
    @PUT
    @Path(value="{name}/{system}")
    @CachePut(cacheName="configuration")
    public void put(@CacheKey @PathParam(value="name") String name, @CacheValue @NotBlank String value, @PathParam(value="system") boolean system) {
        this.put(name, value, system, false);
    }

    @POST
    @PUT
    @Path(value="{name}/{system}/{secured}")
    @CachePut(cacheName="configuration")
    public void put(@CacheKey @PathParam(value="name") String name, @CacheValue @NotBlank String value, @PathParam(value="system") boolean system, @PathParam(value="secured") boolean secured) {
        String storedValue;
        SystemConfiguration setting = (SystemConfiguration)this.repository.findByName(name);
        String string = storedValue = secured ? this.cryptoHelper.encrypt(value) : value;
        if (setting == null) {
            SystemConfiguration entity = new SystemConfiguration();
            entity.setName(name);
            entity.setValue(storedValue);
            this.repository.saveAndFlush(entity);
        } else {
            setting.setValue(storedValue);
        }
        if (system) {
            System.setProperty(name, value);
        }
    }

    @POST
    @PUT
    public void put(ConfigurationEditionVo conf) {
        this.self.put(conf.getName(), conf.getValue(), conf.isSystem(), conf.isSecured());
    }

    @DELETE
    @Path(value="{name}")
    @CacheRemove(cacheName="configuration")
    public void delete(@CacheKey @PathParam(value="name") String name) {
        this.delete(name, false);
    }

    @DELETE
    @Path(value="{name}/{system}")
    @CacheRemove(cacheName="configuration")
    public void delete(@CacheKey @PathParam(value="name") String name, @PathParam(value="system") boolean system) {
        this.repository.deleteAllBy("name", name);
        if (system) {
            System.clearProperty(name);
        }
    }
}

