/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.security;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResult;
import javax.transaction.Transactional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.ligoj.bootstrap.dao.system.AuthorizationRepository;
import org.ligoj.bootstrap.model.system.SystemAuthorization;
import org.ligoj.bootstrap.model.system.SystemRole;
import org.ligoj.bootstrap.resource.system.security.AuthorizationEditionVo;
import org.ligoj.bootstrap.resource.system.security.RoleResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

@Path(value="/system/security/authorization")
@Service
@Transactional
@Produces(value={"application/json"})
public class AuthorizationResource {
    @Autowired
    protected AuthorizationRepository repository;
    @Autowired
    private RoleResource resource;
    @Autowired
    protected CacheManager cacheManager;
    @Value(value="${security.filter.methods:GET,POST,DELETE,PUT}")
    private HttpMethod[] methods;

    @GET
    @Path(value="{id:\\d+}")
    @org.springframework.transaction.annotation.Transactional(readOnly=true)
    public SystemAuthorization findById(@PathParam(value="id") Integer id) {
        return (SystemAuthorization)this.repository.findOneExpected(id);
    }

    @GET
    @Path(value="user/ui")
    @org.springframework.transaction.annotation.Transactional(readOnly=true)
    public List<SystemAuthorization> findAuthorizationsUi(@Context SecurityContext context) {
        return this.repository.findAllByLogin(context.getUserPrincipal().getName(), SystemAuthorization.AuthorizationType.UI);
    }

    @GET
    @Path(value="user/api")
    @org.springframework.transaction.annotation.Transactional(readOnly=true)
    public List<SystemAuthorization> findAuthorizationsApi(@Context SecurityContext context) {
        return this.repository.findAllByLogin(context.getUserPrincipal().getName(), SystemAuthorization.AuthorizationType.API);
    }

    @POST
    @Consumes(value={"application/json"})
    @CacheRemoveAll(cacheName="authorizations")
    public int create(AuthorizationEditionVo entity) {
        SystemAuthorization authorization = new SystemAuthorization();
        this.prepareCreate(authorization, entity);
        return (Integer)authorization.getId();
    }

    @PUT
    @Path(value="{id:\\d+}")
    @Consumes(value={"application/json"})
    @CacheRemoveAll(cacheName="authorizations")
    public void update(@PathParam(value="id") int id, AuthorizationEditionVo entity) {
        this.prepareUpdate(id, entity);
    }

    private void prepareCreate(SystemAuthorization authorization, AuthorizationEditionVo entity) {
        SystemRole role = this.resource.findById(entity.getRole());
        authorization.setRole(role);
        authorization.setPattern(entity.getPattern());
        authorization.setType(entity.getType());
        this.repository.save(authorization);
        Optional.ofNullable(this.cacheManager.getCache("user-details")).ifPresent(Cache::clear);
    }

    private void prepareUpdate(int id, AuthorizationEditionVo entity) {
        SystemAuthorization authorization = (SystemAuthorization)this.repository.findOneExpected(id);
        this.prepareCreate(authorization, entity);
    }

    @DELETE
    @Path(value="{id:\\d+}")
    @CacheRemoveAll(cacheName="authorizations")
    public void remove(@PathParam(value="id") int id) {
        this.repository.deleteById(id);
    }

    @CacheResult(cacheName="authorizations")
    public Map<SystemAuthorization.AuthorizationType, Map<String, Map<HttpMethod, List<Pattern>>>> getAuthorizations() {
        EnumMap<SystemAuthorization.AuthorizationType, Map<String, Map<HttpMethod, List<Pattern>>>> authorizationsCache = new EnumMap<SystemAuthorization.AuthorizationType, Map<String, Map<HttpMethod, List<Pattern>>>>(SystemAuthorization.AuthorizationType.class);
        List authorizations = this.repository.findAll();
        authorizations.forEach(a -> this.addAuthorization(this.newCacheRole(this.newCacheType((Map<SystemAuthorization.AuthorizationType, Map<String, Map<HttpMethod, List<Pattern>>>>)authorizationsCache, (SystemAuthorization)a), (SystemAuthorization)a), (SystemAuthorization)a));
        return authorizationsCache;
    }

    private Map<HttpMethod, List<Pattern>> newCacheRole(Map<String, Map<HttpMethod, List<Pattern>>> existingAuthorizations, SystemAuthorization authorization) {
        return existingAuthorizations.computeIfAbsent(authorization.getRole().getName(), r -> new EnumMap(HttpMethod.class));
    }

    private Map<String, Map<HttpMethod, List<Pattern>>> newCacheType(Map<SystemAuthorization.AuthorizationType, Map<String, Map<HttpMethod, List<Pattern>>>> authorizationsCache, SystemAuthorization authorization) {
        return authorizationsCache.computeIfAbsent(authorization.getType(), a -> new HashMap());
    }

    private void addAuthorization(Map<HttpMethod, List<Pattern>> existingAuthorizations, SystemAuthorization authorization) {
        if (authorization.getMethod() == null) {
            for (HttpMethod method : this.methods) {
                this.addAuthorization(existingAuthorizations, method, authorization.getPattern());
            }
        } else {
            this.addAuthorization(existingAuthorizations, authorization.getMethod(), authorization.getPattern());
        }
    }

    private void addAuthorization(Map<HttpMethod, List<Pattern>> existingAuthorizations, HttpMethod method, String pattern) {
        existingAuthorizations.computeIfAbsent(method, m -> new ArrayList()).add(Pattern.compile(pattern));
    }
}

