/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.ligoj.bootstrap.dao.system.AuthorizationRepository;
import org.ligoj.bootstrap.model.system.SystemAuthorization;
import org.ligoj.bootstrap.resource.system.security.AuthorizationResource;
import org.ligoj.bootstrap.resource.system.session.ISessionSettingsProvider;
import org.ligoj.bootstrap.resource.system.session.SessionSettings;
import org.ligoj.bootstrap.resource.system.user.UserSettingResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Path(value="/session")
@Service
@Produces(value={"application/json"})
public class SessionResource {
    @Autowired
    protected AuthorizationRepository repository;
    @Autowired
    protected UserSettingResource userSettingResource;
    @Autowired
    protected ApplicationContext applicationContext;
    private static final List<Map<HttpMethod, List<Pattern>>> EMPTY_ROLES = new ArrayList<Map<HttpMethod, List<Pattern>>>();
    @Autowired
    private AuthorizationResource authorizationResource;

    @GET
    @Transactional
    public SessionSettings details() {
        SessionSettings settings = (SessionSettings)this.applicationContext.getBean(SessionSettings.class);
        settings.setUserSettings(this.userSettingResource.findAll());
        this.addAuthorizations(settings);
        this.applicationContext.getBeansOfType(ISessionSettingsProvider.class).values().forEach(p -> p.decorate(settings));
        return settings;
    }

    private void addAuthorizations(SessionSettings settings) {
        List<String> rolesAsString = this.getRolesAsString();
        settings.setRoles(rolesAsString);
        Map<SystemAuthorization.AuthorizationType, Map<String, Map<HttpMethod, List<Pattern>>>> cache = this.authorizationResource.getAuthorizations();
        settings.setUiAuthorizations(this.toPatterns(this.filterRoles(cache.get(SystemAuthorization.AuthorizationType.UI), rolesAsString)));
        settings.setApiAuthorizations(this.getApiAuthorizations(this.filterRoles(cache.get(SystemAuthorization.AuthorizationType.API), rolesAsString)));
    }

    private List<Map<HttpMethod, List<Pattern>>> filterRoles(Map<String, Map<HttpMethod, List<Pattern>>> authorizations, List<String> rolesAsString) {
        if (authorizations == null) {
            return EMPTY_ROLES;
        }
        return rolesAsString.stream().map(authorizations::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Set<String> toPatterns(List<Map<HttpMethod, List<Pattern>>> authorizations) {
        return authorizations.stream().map(Map::values).flatMap(Collection::stream).flatMap(Collection::stream).map(Pattern::pattern).collect(Collectors.toSet());
    }

    private List<String> getRolesAsString() {
        Collection roles = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
        return roles.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
    }

    private List<SystemAuthorization> getApiAuthorizations(List<Map<HttpMethod, List<Pattern>>> authorizations) {
        return authorizations.stream().map(Map::entrySet).flatMap(Collection::stream).flatMap(entry -> ((List)entry.getValue()).stream().map(pattern -> {
            SystemAuthorization apiAuthorization = new SystemAuthorization();
            apiAuthorization.setMethod((HttpMethod)entry.getKey());
            apiAuthorization.setPattern(pattern.pattern());
            return apiAuthorization;
        })).collect(Collectors.toList());
    }
}

