/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.user;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheRemove;
import javax.persistence.criteria.JoinType;
import javax.transaction.Transactional;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.ligoj.bootstrap.core.dao.PaginationDao;
import org.ligoj.bootstrap.core.json.PaginationJson;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.dao.system.SystemRoleAssignmentRepository;
import org.ligoj.bootstrap.dao.system.SystemUserRepository;
import org.ligoj.bootstrap.model.system.SystemRole;
import org.ligoj.bootstrap.model.system.SystemRoleAssignment;
import org.ligoj.bootstrap.model.system.SystemUser;
import org.ligoj.bootstrap.resource.system.security.SystemRoleVo;
import org.ligoj.bootstrap.resource.system.user.SystemUserEditionVo;
import org.ligoj.bootstrap.resource.system.user.SystemUserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Path(value="/system/user")
@Transactional
@Produces(value={"application/json"})
public class UserResource {
    @Autowired
    private PaginationDao pagination;
    @Autowired
    private PaginationJson paginationJson;
    @Autowired
    private SystemUserRepository repository;
    @Autowired
    private SystemRoleAssignmentRepository roleAssignmentRepository;
    @Autowired
    protected CacheManager cacheManager;
    private static final Map<String, String> ORDERED_COLUMNS = new HashMap<String, String>();
    private static final Map<String, JoinType> FETCHED_ASSOCS;
    private static final ToBusinessConverterRole TO_BUSINESS_ROLES;
    private static final ToBusinessConverter TO_BUSINESS;

    @GET
    @Path(value="{login}")
    public SystemUser findById(@PathParam(value="login") String login) {
        return (SystemUser)this.repository.findOneExpected(login);
    }

    @GET
    public TableItem<String> findAll(@Context UriInfo uriInfo) {
        return this.paginationJson.applyPagination(uriInfo, this.repository.findAll((Pageable)this.paginationJson.getPageRequest(uriInfo, ORDERED_COLUMNS)), TO_BUSINESS);
    }

    @GET
    @Path(value="roles")
    public TableItem<SystemUserVo> findAllWithRoles(@Context UriInfo uriInfo) {
        Page<SystemUser> findAll = this.pagination.findAll(SystemUser.class, uriInfo, ORDERED_COLUMNS, null, FETCHED_ASSOCS);
        return this.paginationJson.applyPagination(uriInfo, findAll, TO_BUSINESS_ROLES);
    }

    @POST
    public void create(SystemUserEditionVo userVo) {
        SystemUser user = new SystemUser();
        user.setLogin(userVo.getLogin());
        user = (SystemUser)this.repository.save(user);
        this.createRoleAssignment(userVo.getRoles(), user);
    }

    @PUT
    public void update(SystemUserEditionVo userVo) {
        SystemUser user = (SystemUser)this.repository.findOneExpected(userVo.getLogin());
        ArrayList<SystemRoleAssignment> roleToDelete = new ArrayList<SystemRoleAssignment>();
        for (SystemRoleAssignment role : user.getRoles()) {
            if (userVo.getRoles().contains(role.getRole().getId())) {
                userVo.getRoles().remove(role.getRole().getId());
                continue;
            }
            roleToDelete.add(role);
        }
        this.roleAssignmentRepository.deleteAll(roleToDelete);
        user.getRoles().removeAll(roleToDelete);
        this.createRoleAssignment(userVo.getRoles(), user);
    }

    private void createRoleAssignment(List<Integer> roleIds, SystemUser user) {
        for (Integer roleId : roleIds) {
            SystemRoleAssignment roleAssignment = new SystemRoleAssignment();
            SystemRole role = new SystemRole();
            role.setId((Serializable)roleId);
            roleAssignment.setRole(role);
            roleAssignment.setUser(user);
            this.roleAssignmentRepository.save(roleAssignment);
        }
        this.cacheManager.getCache("user-details").evict((Object)user.getLogin());
    }

    @DELETE
    @Path(value="{login}")
    @CacheRemove(cacheName="user-details")
    public void delete(@PathParam(value="login") @CacheKey String login) {
        this.repository.deleteById(login);
    }

    static {
        ORDERED_COLUMNS.put("login", "login");
        ORDERED_COLUMNS.put("role", "roles.role.name");
        FETCHED_ASSOCS = new HashMap<String, JoinType>();
        FETCHED_ASSOCS.put("roles", JoinType.LEFT);
        TO_BUSINESS_ROLES = new ToBusinessConverterRole();
        TO_BUSINESS = new ToBusinessConverter();
    }

    private static class ToBusinessConverter
    implements Function<SystemUser, String> {
        private ToBusinessConverter() {
        }

        @Override
        public String apply(SystemUser user) {
            return user.getLogin();
        }
    }

    private static class ToBusinessConverterRole
    implements Function<SystemUser, SystemUserVo> {
        private ToBusinessConverterRole() {
        }

        @Override
        public SystemUserVo apply(SystemUser user) {
            SystemUserVo userVo = new SystemUserVo();
            userVo.setLogin(user.getLogin());
            userVo.setRoles(new ArrayList<SystemRoleVo>());
            Set roles = user.getRoles();
            for (SystemRoleAssignment role : roles) {
                SystemRoleVo systemRoleVo = new SystemRoleVo();
                systemRoleVo.setId((Integer)role.getRole().getId());
                systemRoleVo.setName(role.getRole().getName());
                userVo.getRoles().add(systemRoleVo);
            }
            return userVo;
        }
    }
}

