/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.ligoj.bootstrap.core.dao.AbstractSpecification;
import org.ligoj.bootstrap.core.dao.CustomSpecification;
import org.ligoj.bootstrap.core.dao.RuleToPredicate;
import org.ligoj.bootstrap.core.json.jqgrid.BasicRule;
import org.ligoj.bootstrap.core.json.jqgrid.UIRule;
import org.ligoj.bootstrap.core.json.jqgrid.UiFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;

class DynamicSpecification<U>
extends AbstractSpecification
implements Specification<U> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicSpecification.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_DELIMITERS = "_\\.";
    private static final String LIKE = "%";
    private static final EnumMap<BasicRule.RuleOperator, RuleToPredicate> PREDICATE_MAPPER = new EnumMap(BasicRule.RuleOperator.class);
    private final transient EntityManager em;
    private final transient UiFilter filter;
    private final transient Map<String, String> mapping;
    private final transient Map<String, CustomSpecification> specifications;

    DynamicSpecification(EntityManager em, UiFilter filter, Map<String, String> mapping, Map<String, CustomSpecification> specifications) {
        this.em = em;
        this.filter = filter;
        this.mapping = MapUtils.emptyIfNull(mapping);
        this.specifications = MapUtils.emptyIfNull(specifications);
    }

    private Predicate getCustomPredicate(Root<U> root, CriteriaBuilder cb, BasicRule rule, CriteriaQuery<?> query) {
        CustomSpecification specification = this.specifications.get(rule.getField());
        if (specification == null) {
            log.error("A CustomSpecification must be defined when custom operator type ('ct') is used");
            return null;
        }
        return specification.toPredicate(root, query, cb, rule);
    }

    private Predicate getGroupPredicate(UiFilter group, Root<U> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        List<Predicate> predicates = this.getPredicates(group, root, query, cb);
        if (predicates.isEmpty()) {
            return cb.conjunction();
        }
        Predicate[] filteredPredicates = predicates.toArray(new Predicate[0]);
        if (group.getGroupOp() == UiFilter.FilterOperator.AND) {
            return cb.and(filteredPredicates);
        }
        return cb.or(filteredPredicates);
    }

    private <T> Path<T> getOrmPath(Root<U> root, BasicRule rule) {
        String path = this.mapping.getOrDefault(rule.getField(), this.mapping.containsKey("*") ? rule.getField() : null);
        if (path == null) {
            log.error(String.format("Non mapped property '%s' found for entity class '%s'", rule.getField(), root.getJavaType().getName()));
            return null;
        }
        return this.getOrmPath(root, path);
    }

    private <X extends Comparable<Object>> Predicate getPredicate(CriteriaBuilder cb, BasicRule rule, Expression<X> expression) {
        return PREDICATE_MAPPER.get((Object)rule.getOp()).toPredicate(this.em, cb, rule.getData(), expression);
    }

    private Predicate getPredicate(Root<U> root, CriteriaBuilder cb, BasicRule rule, CriteriaQuery<?> query) {
        if (rule.getOp() == BasicRule.RuleOperator.CT) {
            return this.getCustomPredicate(root, cb, rule, query);
        }
        Path expression = this.getOrmPath(root, rule);
        if (expression == null) {
            log.info(String.format("SQL injection attack ? Unable to map request rule for property %s", rule.getField()));
            return null;
        }
        return this.getPredicate(cb, rule, (Expression)expression);
    }

    private Predicate getPredicate(Root<U> root, CriteriaQuery<?> query, CriteriaBuilder cb, UIRule rule) {
        if (rule instanceof BasicRule) {
            BasicRule r = (BasicRule)rule;
            return this.getPredicate(root, cb, r, query);
        }
        return this.getGroupPredicate((UiFilter)rule, root, query, cb);
    }

    private List<Predicate> getPredicates(UiFilter group, Root<U> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        return group.getRules().stream().map(rule -> this.getPredicate(root, query, cb, (UIRule)rule)).filter(Objects::nonNull).toList();
    }

    public Predicate toPredicate(Root<U> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        return this.getGroupPredicate(this.filter, root, query, cb);
    }

    static {
        PREDICATE_MAPPER.put(BasicRule.RuleOperator.BW, (em, cb, d, e) -> cb.like(cb.upper(e.as(String.class)), d.toUpperCase(Locale.ENGLISH) + LIKE));
        PREDICATE_MAPPER.put(BasicRule.RuleOperator.CN, (em, cb, d, e) -> cb.like(cb.upper(e.as(String.class)), LIKE + d.toUpperCase(Locale.ENGLISH) + LIKE));
        PREDICATE_MAPPER.put(BasicRule.RuleOperator.EW, (em, cb, d, e) -> cb.like(cb.upper(e.as(String.class)), LIKE + d.toUpperCase(Locale.ENGLISH)));
        PREDICATE_MAPPER.put(BasicRule.RuleOperator.GT, (em, cb, d, e) -> cb.greaterThan(e, (Comparable)DynamicSpecification.toRawData(em, d, e)));
        PREDICATE_MAPPER.put(BasicRule.RuleOperator.GTE, (em, cb, d, e) -> cb.greaterThanOrEqualTo(e, (Comparable)DynamicSpecification.toRawData(em, d, e)));
        PREDICATE_MAPPER.put(BasicRule.RuleOperator.LT, (em, cb, d, e) -> cb.lessThan(e, (Comparable)DynamicSpecification.toRawData(em, d, e)));
        PREDICATE_MAPPER.put(BasicRule.RuleOperator.LTE, (em, cb, d, e) -> cb.lessThanOrEqualTo(e, (Comparable)DynamicSpecification.toRawData(em, d, e)));
        PREDICATE_MAPPER.put(BasicRule.RuleOperator.NE, (em, cb, d, e) -> cb.notEqual(e, DynamicSpecification.toRawData(em, d, e)));
        PREDICATE_MAPPER.put(BasicRule.RuleOperator.EQ, (em, cb, d, e) -> cb.equal(e, DynamicSpecification.toRawData(em, d, e)));
    }
}

