/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.bootstrap.core.SpringUtils;
import org.ligoj.bootstrap.core.dao.FetchHelper;
import org.ligoj.bootstrap.core.dao.RestRepository;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Transactional;

public class RestRepositoryImpl<T, K extends Serializable>
extends SimpleJpaRepository<T, K>
implements RestRepository<T, K> {
    private final EntityManager em;
    private final JpaEntityInformation<T, ?> ei;
    private static final String SELECT_BY = "FROM %s WHERE ";
    private static final String DELETE_ALL = "DELETE %s";
    private static final String DELETE_BY = "DELETE %s WHERE ";
    private static final String DELETE_ALL_IN = "DELETE %s WHERE %s IN (:%s)";
    private static final String PARAM_VALUE = "value";

    public RestRepositoryImpl(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.ei = entityInformation;
        this.em = entityManager;
    }

    @Override
    public T findOneExpected(K id) {
        return this.findOneExpected(id, null);
    }

    @Override
    public T findOneExpected(K id, Map<String, JoinType> fetchedAssociations) {
        Object entity = org.springframework.util.CollectionUtils.isEmpty(fetchedAssociations) ? this.findOne((Serializable)id) : this.findOne(id, fetchedAssociations);
        return (T)Optional.ofNullable(entity).orElseThrow(() -> new EntityNotFoundException(id.toString()));
    }

    private T findOne(K id, Map<String, JoinType> fetchedAssociations) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(this.getDomainClass());
        Root root = query.from(this.getDomainClass());
        ((FetchHelper)SpringUtils.getBean(FetchHelper.class)).applyFetchedAssociations(fetchedAssociations, root);
        Specification & Serializable specification = (Specification & Serializable)(r, q, cb) -> cb.equal((Expression)r.get("id"), id);
        query.where((Expression)specification.toPredicate(root, query, builder));
        query.select((Selection)root);
        return (T)this.em.createQuery(query).getSingleResult();
    }

    @Override
    @Transactional
    public void deleteNoFetch(K id) {
        if (this.update(DELETE_BY, "id", id, ArrayUtils.EMPTY_STRING_ARRAY, new Object[0]) != 1) {
            throw new EntityNotFoundException(id.toString());
        }
    }

    @Override
    @Transactional
    public int deleteAll(Collection<K> identifiers) {
        if (CollectionUtils.isEmpty(identifiers)) {
            return 0;
        }
        return this.update(DELETE_ALL_IN, "id", identifiers, ArrayUtils.EMPTY_STRING_ARRAY, new Object[0]);
    }

    @Override
    @Transactional
    public int deleteAllExpected(Collection<K> identifiers) {
        int deleted = this.deleteAll(identifiers);
        if (deleted != CollectionUtils.size(identifiers)) {
            throw new EntityNotFoundException(identifiers.toString());
        }
        return deleted;
    }

    @Override
    @Transactional
    public int deleteAllNoFetch() {
        return this.em.createQuery(String.format(DELETE_ALL, this.ei.getEntityName())).executeUpdate();
    }

    @Override
    public void existExpected(K id) {
        if (!this.existsById(id)) {
            throw new EntityNotFoundException(id.toString());
        }
    }

    @Override
    public T findBy(String property, Object value) {
        return this.findBy(property, value, ArrayUtils.EMPTY_STRING_ARRAY, new Object[0]);
    }

    @Override
    public T findBy(String property, Object value, String[] properties, Object ... values) {
        return this.newQuery(SELECT_BY, property, value, properties, values).setMaxResults(1).getResultList().stream().findFirst().orElse(null);
    }

    @Override
    public T findByName(String name) {
        return this.findBy("name", name);
    }

    @Override
    public T findByNameExpected(String name) {
        return this.findByExpected("name", name);
    }

    @Override
    public T findByExpected(String property, Object value) {
        return Optional.ofNullable(this.findBy(property, value)).orElseThrow(() -> new EntityNotFoundException(String.valueOf(value)));
    }

    @Override
    @Transactional
    public int deleteAllBy(String property, Object value) {
        return this.deleteAllBy(property, value, ArrayUtils.EMPTY_STRING_ARRAY, new Object[0]);
    }

    @Override
    public int deleteAllBy(String property, Object value, String[] properties, Object ... values) {
        return this.update(DELETE_BY, property, value, properties, values);
    }

    @Override
    public List<T> findAllBy(String property, Object value) {
        return this.findAllBy(property, value, ArrayUtils.EMPTY_STRING_ARRAY, new Object[0]);
    }

    @Override
    public List<T> findAllBy(String property, Object value, String[] properties, Object ... values) {
        return this.newQuery(SELECT_BY, property, value, properties, values).getResultList();
    }

    private TypedQuery<T> newQuery(String patternQuery, String property, Object value, String[] properties, Object ... values) {
        StringBuilder baseQuery = this.newQueryString(patternQuery, property, value, properties, values);
        return this.addParameters(this.em.createQuery(baseQuery.toString(), this.ei.getJavaType()), value, values);
    }

    private int update(String patternQuery, String property, Object value, String[] properties, Object ... values) {
        StringBuilder baseQuery = this.newQueryString(patternQuery, property, value, properties, values);
        return this.addParameters(this.em.createQuery(baseQuery.toString()), value, values).executeUpdate();
    }

    @Override
    public long countBy(String property, Object value) {
        return (Long)this.em.createQuery(String.format("SELECT COUNT(*) FROM %s WHERE %s=:value", this.ei.getEntityName(), property), Long.class).setParameter(PARAM_VALUE, value).getSingleResult();
    }

    private StringBuilder newQueryString(String patternQuery, String property, Object value, String[] properties, Object ... values) {
        StringBuilder baseQuery;
        if (StringUtils.countMatches((CharSequence)patternQuery, (CharSequence)"%s") == 1) {
            baseQuery = new StringBuilder(String.format(patternQuery, this.ei.getEntityName()));
            this.addFilter(baseQuery, property, value, 0);
        } else {
            baseQuery = new StringBuilder(String.format(patternQuery, this.ei.getEntityName(), property, "value0"));
        }
        for (int index = 0; index < values.length; ++index) {
            baseQuery.append(" AND ");
            this.addFilter(baseQuery, properties[index], values[index], index + 1);
        }
        return baseQuery;
    }

    private void addFilter(StringBuilder baseQuery, String property, Object value, int index) {
        baseQuery.append(property);
        if (value == null) {
            baseQuery.append(" IS NULL");
        } else {
            baseQuery.append("=:");
            baseQuery.append(PARAM_VALUE);
            baseQuery.append(index);
        }
    }

    private <Q extends Query> Q addParameters(Q query, Object value, Object ... values) {
        this.addParameter(query, value, 0);
        for (int index = 0; index < values.length; ++index) {
            this.addParameter(query, values[index], index + 1);
        }
        return query;
    }

    private void addParameter(Query query, Object value, int index) {
        if (value != null) {
            query.setParameter(PARAM_VALUE + index, value);
        }
    }
}

