/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.ligoj.bootstrap.core.DateUtils;

public class LocalDateTimeDeserializer
extends StdDeserializer<LocalDateTime> {
    private static final long serialVersionUID = 1L;
    public static final LocalDateTimeDeserializer INSTANCE = new LocalDateTimeDeserializer();

    protected LocalDateTimeDeserializer() {
        super(LocalTime.class);
    }

    public LocalDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        if (parser.getCurrentToken() == JsonToken.VALUE_NUMBER_INT) {
            return Instant.ofEpochMilli(parser.getLongValue()).atZone(DateUtils.getApplicationTimeZone().toZoneId()).toLocalDateTime();
        }
        return null;
    }
}

