/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.security;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.ligoj.bootstrap.resource.system.api.ApiTokenResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.authentication.preauth.RequestHeaderAuthenticationFilter;

public class ApiTokenAuthenticationFilter
extends RequestHeaderAuthenticationFilter {
    @Autowired
    private ApiTokenResource resource;

    public ApiTokenAuthenticationFilter() {
        this.setCredentialsRequestHeader("x-api-key");
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String principal = (String)super.getPreAuthenticatedPrincipal(request);
        String credential = (String)super.getPreAuthenticatedCredentials(request);
        if (principal == null || credential == null || this.resource.check(Objects.requireNonNullElse(request.getHeader("x-api-via-user"), principal), credential)) {
            return principal;
        }
        return null;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return ObjectUtils.defaultIfNull((Object)super.getPreAuthenticatedCredentials(request), (Object)"N/A");
    }

    @Generated
    public void setResource(ApiTokenResource resource) {
        this.resource = resource;
    }
}

