/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.bench;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.ligoj.bootstrap.core.json.ObjectMapperTrim;
import org.ligoj.bootstrap.core.resource.OnNullReturn404;
import org.ligoj.bootstrap.dao.system.BenchResult;
import org.ligoj.bootstrap.dao.system.ISystemPerformanceJpaDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="/system/bench")
@Produces(value={"application/json"})
@Service
public class JpaBenchResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JpaBenchResource.class);
    @Autowired
    private ISystemPerformanceJpaDao jpaDao;

    @POST
    @PUT
    @Produces(value={"text/html"})
    @Consumes(value={"application/x-www-form-urlencoded", "multipart/form-data"})
    @Path(value="prepare")
    public String prepareData(@Multipart(value="nb", required=false) String nb, @Multipart(value="blob", required=false) InputStream blob) throws IOException {
        long start = System.currentTimeMillis();
        byte[] lobData = blob == null ? new byte[]{} : IOUtils.toByteArray((InputStream)blob);
        log.info("Content size: {}", (Object)lobData.length);
        BenchResult result = this.jpaDao.initialize(Integer.parseInt(nb), lobData);
        result.setDuration(System.currentTimeMillis() - start);
        return new ObjectMapperTrim().writeValueAsString(result);
    }

    @GET
    @Path(value="read")
    public BenchResult benchRead() {
        long start = System.currentTimeMillis();
        BenchResult result = this.jpaDao.benchRead();
        result.setDuration(System.currentTimeMillis() - start);
        return result;
    }

    @GET
    @Path(value="read/all")
    public BenchResult benchReadAll() {
        long start = System.currentTimeMillis();
        BenchResult result = this.jpaDao.benchReadAll();
        result.setDuration(System.currentTimeMillis() - start);
        return result;
    }

    @PUT
    @Path(value="update")
    public BenchResult benchUpdate() {
        long start = System.currentTimeMillis();
        BenchResult result = this.jpaDao.benchUpdate();
        result.setDuration(System.currentTimeMillis() - start);
        return result;
    }

    @DELETE
    @Path(value="delete")
    public BenchResult benchDelete() {
        long start = System.currentTimeMillis();
        BenchResult result = this.jpaDao.benchDelete();
        result.setDuration(System.currentTimeMillis() - start);
        return result;
    }

    @GET
    @Path(value="picture.png")
    @Produces(value={"application/octet-stream"})
    @OnNullReturn404
    public StreamingOutput downloadLobFile() {
        log.info("Picture download is requested");
        byte[] firstAvailableLob = this.jpaDao.getLastAvailableLob();
        if (firstAvailableLob.length == 0) {
            return null;
        }
        return output -> {
            try {
                IOUtils.write((byte[])firstAvailableLob, (OutputStream)output);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to write the LOB data", e);
            }
        };
    }
}

