/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.security;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResult;
import org.ligoj.bootstrap.dao.system.AuthorizationRepository;
import org.ligoj.bootstrap.model.system.SystemAuthorization;
import org.ligoj.bootstrap.model.system.SystemRole;
import org.ligoj.bootstrap.resource.system.security.AuthorizationEditionVo;
import org.ligoj.bootstrap.resource.system.security.RoleResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

@Path(value="/system/security/authorization")
@Service
@Transactional
@Produces(value={"application/json"})
public class AuthorizationResource {
    @Autowired
    protected AuthorizationRepository repository;
    @Autowired
    private RoleResource resource;
    @Autowired
    protected CacheManager cacheManager;
    @Value(value="${security.filter.methods:GET,POST,DELETE,PUT}")
    private String[] methods;

    @GET
    @Path(value="{id:\\d+}")
    @org.springframework.transaction.annotation.Transactional(readOnly=true)
    public SystemAuthorization findById(@PathParam(value="id") Integer id) {
        return (SystemAuthorization)this.repository.findOneExpected(id);
    }

    @GET
    @Path(value="user/ui")
    @org.springframework.transaction.annotation.Transactional(readOnly=true)
    public List<SystemAuthorization> findAuthorizationsUi(@Context SecurityContext context) {
        return this.repository.findAllByLogin(context.getUserPrincipal().getName(), SystemAuthorization.AuthorizationType.UI);
    }

    @GET
    @Path(value="user/api")
    @org.springframework.transaction.annotation.Transactional(readOnly=true)
    public List<SystemAuthorization> findAuthorizationsApi(@Context SecurityContext context) {
        return this.repository.findAllByLogin(context.getUserPrincipal().getName(), SystemAuthorization.AuthorizationType.API);
    }

    @POST
    @Consumes(value={"application/json"})
    @CacheRemoveAll(cacheName="authorizations")
    public int create(AuthorizationEditionVo entity) {
        SystemAuthorization authorization = new SystemAuthorization();
        this.prepareCreate(authorization, entity);
        return (Integer)authorization.getId();
    }

    @PUT
    @Path(value="{id:\\d+}")
    @Consumes(value={"application/json"})
    @CacheRemoveAll(cacheName="authorizations")
    public void update(@PathParam(value="id") int id, AuthorizationEditionVo entity) {
        this.prepareUpdate(id, entity);
    }

    private void prepareCreate(SystemAuthorization authorization, AuthorizationEditionVo entity) {
        SystemRole role = this.resource.findById(entity.getRole());
        authorization.setRole(role);
        authorization.setPattern(entity.getPattern());
        authorization.setType(entity.getType());
        this.repository.saveAndFlush(authorization);
        Optional.ofNullable(this.cacheManager.getCache("user-details")).ifPresent(Cache::clear);
    }

    private void prepareUpdate(int id, AuthorizationEditionVo entity) {
        SystemAuthorization authorization = (SystemAuthorization)this.repository.findOneExpected(id);
        this.prepareCreate(authorization, entity);
    }

    @DELETE
    @Path(value="{id:\\d+}")
    @CacheRemoveAll(cacheName="authorizations")
    public void remove(@PathParam(value="id") int id) {
        this.repository.deleteById(id);
    }

    @CacheResult(cacheName="authorizations")
    public Map<SystemAuthorization.AuthorizationType, Map<String, Map<String, List<Pattern>>>> getAuthorizations() {
        EnumMap<SystemAuthorization.AuthorizationType, Map<String, Map<String, List<Pattern>>>> cache = new EnumMap<SystemAuthorization.AuthorizationType, Map<String, Map<String, List<Pattern>>>>(SystemAuthorization.AuthorizationType.class);
        this.repository.findAll().forEach(a -> this.addAuthorization(this.newCacheRole(this.newCacheType((Map<SystemAuthorization.AuthorizationType, Map<String, Map<String, List<Pattern>>>>)cache, (SystemAuthorization)a), (SystemAuthorization)a), (SystemAuthorization)a));
        return cache;
    }

    private Map<String, List<Pattern>> newCacheRole(Map<String, Map<String, List<Pattern>>> existingAuthorizations, SystemAuthorization authorization) {
        return existingAuthorizations.computeIfAbsent(authorization.getRole().getName(), r -> new HashMap());
    }

    private Map<String, Map<String, List<Pattern>>> newCacheType(Map<SystemAuthorization.AuthorizationType, Map<String, Map<String, List<Pattern>>>> authorizationsCache, SystemAuthorization authorization) {
        return authorizationsCache.computeIfAbsent(authorization.getType(), a -> new HashMap());
    }

    private void addAuthorization(Map<String, List<Pattern>> existingAuthorizations, SystemAuthorization authorization) {
        if (authorization.getMethod() == null) {
            Stream.of(this.methods).forEach(m -> this.addAuthorization(existingAuthorizations, (String)m, authorization.getPattern()));
        } else {
            this.addAuthorization(existingAuthorizations, authorization.getMethod(), authorization.getPattern());
        }
    }

    private void addAuthorization(Map<String, List<Pattern>> existingAuthorizations, String method, String pattern) {
        existingAuthorizations.computeIfAbsent(method, m -> new ArrayList()).add(Pattern.compile(pattern));
    }
}

