/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.session;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ligoj.bootstrap.dao.system.AuthorizationRepository;
import org.ligoj.bootstrap.model.system.SystemAuthorization;
import org.ligoj.bootstrap.resource.system.security.AuthorizationResource;
import org.ligoj.bootstrap.resource.system.session.ISessionSettingsProvider;
import org.ligoj.bootstrap.resource.system.session.SessionSettings;
import org.ligoj.bootstrap.resource.system.user.UserSettingResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Path(value="/session")
@Service
@Produces(value={"application/json"})
public class SessionResource {
    @Autowired
    protected AuthorizationRepository repository;
    @Autowired
    protected UserSettingResource userSettingResource;
    @Autowired
    protected ApplicationContext applicationContext;
    private static final List<Map<String, List<Pattern>>> EMPTY_ROLES = new ArrayList<Map<String, List<Pattern>>>();
    @Autowired
    private AuthorizationResource authorizationResource;

    @GET
    @Transactional
    public SessionSettings details() {
        SessionSettings settings = (SessionSettings)this.applicationContext.getBean(SessionSettings.class);
        settings.setUserSettings(this.userSettingResource.findAll());
        this.addAuthorizations(settings);
        this.applicationContext.getBeansOfType(ISessionSettingsProvider.class).values().forEach(p -> p.decorate(settings));
        return settings;
    }

    private void addAuthorizations(SessionSettings settings) {
        List<String> rolesAsString = this.getRolesAsString();
        settings.setRoles(rolesAsString);
        Map<SystemAuthorization.AuthorizationType, Map<String, Map<String, List<Pattern>>>> cache = this.authorizationResource.getAuthorizations();
        settings.setUiAuthorizations(this.toPatterns(this.filterRoles(cache.get(SystemAuthorization.AuthorizationType.UI), rolesAsString)));
        settings.setApiAuthorizations(this.getApiAuthorizations(this.filterRoles(cache.get(SystemAuthorization.AuthorizationType.API), rolesAsString)));
    }

    private List<Map<String, List<Pattern>>> filterRoles(Map<String, Map<String, List<Pattern>>> authorizations, List<String> rolesAsString) {
        if (authorizations == null) {
            return EMPTY_ROLES;
        }
        return rolesAsString.stream().map(authorizations::get).filter(Objects::nonNull).toList();
    }

    private Set<String> toPatterns(List<Map<String, List<Pattern>>> authorizations) {
        return authorizations.stream().map(Map::values).flatMap(Collection::stream).flatMap(Collection::stream).map(Pattern::pattern).collect(Collectors.toSet());
    }

    private List<String> getRolesAsString() {
        Collection roles = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
        return roles.stream().map(GrantedAuthority::getAuthority).toList();
    }

    private List<SystemAuthorization> getApiAuthorizations(List<Map<String, List<Pattern>>> authorizations) {
        return authorizations.stream().map(Map::entrySet).flatMap(Collection::stream).flatMap(entry -> ((List)entry.getValue()).stream().map(pattern -> {
            SystemAuthorization apiAuthorization = new SystemAuthorization();
            apiAuthorization.setMethod((String)entry.getKey());
            apiAuthorization.setPattern(pattern.pattern());
            return apiAuthorization;
        })).toList();
    }
}

