/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.user;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ligoj.bootstrap.core.model.AbstractNamedAuditedEntity;
import org.ligoj.bootstrap.dao.system.SystemUserSettingRepository;
import org.ligoj.bootstrap.model.system.AbstractNamedValue;
import org.ligoj.bootstrap.model.system.SystemUserSetting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
@Path(value="/system/setting")
@Transactional
@Produces(value={"application/json"})
public class UserSettingResource {
    @Autowired
    private SystemUserSettingRepository repository;

    @DELETE
    @Path(value="{name}")
    public void delete(@PathParam(value="name") String name) {
        this.repository.delete(SecurityContextHolder.getContext().getAuthentication().getName(), name);
    }

    @GET
    public Map<String, Object> findAll() {
        return this.findAll(SecurityContextHolder.getContext().getAuthentication().getName());
    }

    public Map<String, Object> findAll(String login) {
        return this.repository.findByLogin(login).stream().collect(Collectors.toMap(AbstractNamedAuditedEntity::getName, AbstractNamedValue::getValue));
    }

    @GET
    @Path(value="{name}")
    public Object findByName(String name) {
        return this.findByName(SecurityContextHolder.getContext().getAuthentication().getName(), name);
    }

    public String findByName(String login, String name) {
        return Optional.ofNullable(this.repository.findByLoginAndName(login, name)).map(AbstractNamedValue::getValue).orElse(null);
    }

    @POST
    @PUT
    @Path(value="/system/admin-setting/{user}/{name}/{value}")
    public void saveOrUpdate(@PathParam(value="name") String user, @PathParam(value="name") String name, @PathParam(value="value") String value) {
        SystemUserSetting setting = this.repository.findByLoginAndName(user, name);
        if (setting == null) {
            SystemUserSetting entity = new SystemUserSetting();
            entity.setLogin(user);
            entity.setName(name);
            entity.setValue(value);
            this.repository.saveAndFlush(entity);
        } else {
            setting.setValue(value);
        }
    }

    @POST
    @PUT
    @Path(value="{name}/{value}")
    public void saveOrUpdate(@PathParam(value="name") String name, @PathParam(value="value") String value) {
        String user = SecurityContextHolder.getContext().getAuthentication().getName();
        this.saveOrUpdate(user, name, value);
    }
}

