/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.ligoj.bootstrap.core.DateUtils;

public class DateDeserializer
extends StdDeserializer<Date> {
    private static final long serialVersionUID = 1L;
    public static final DateDeserializer INSTANCE = new DateDeserializer();

    protected DateDeserializer() {
        super(Date.class);
    }

    public Date deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        if (parser.getCurrentToken() == JsonToken.VALUE_NUMBER_INT) {
            Calendar newCalendar = DateUtils.newCalendar();
            newCalendar.setTimeInMillis(parser.getLongValue());
            return newCalendar.getTime();
        }
        if (parser.getCurrentToken() == JsonToken.VALUE_NUMBER_FLOAT) {
            Calendar newCalendar = DateUtils.newCalendar();
            newCalendar.setTimeInMillis((long)parser.getDoubleValue());
            return newCalendar.getTime();
        }
        return this._parseDate(parser, context);
    }
}

