/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.ligoj.bootstrap.core.json.DateDeserializer;
import org.ligoj.bootstrap.core.json.DateSerializer;
import org.ligoj.bootstrap.core.json.LocalDateDeserializer;
import org.ligoj.bootstrap.core.json.LocalDateSerializer;
import org.ligoj.bootstrap.core.json.LocalDateTimeDeserializer;
import org.ligoj.bootstrap.core.json.LocalDateTimeSerializer;

public class ObjectMapperTrim
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public ObjectMapperTrim() {
        SimpleModule module = new SimpleModule("BootstrapModule", new Version(1, 0, 1, null, null, null));
        module.addDeserializer(Date.class, (JsonDeserializer)DateDeserializer.INSTANCE);
        module.addDeserializer(LocalDate.class, (JsonDeserializer)LocalDateDeserializer.INSTANCE);
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)LocalDateTimeDeserializer.INSTANCE);
        module.addSerializer(Date.class, (JsonSerializer)DateSerializer.INSTANCE);
        module.addSerializer(LocalDate.class, (JsonSerializer)LocalDateSerializer.INSTANCE);
        module.addSerializer(LocalDateTime.class, (JsonSerializer)LocalDateTimeSerializer.INSTANCE);
        module.addSerializer(Enum.class, (JsonSerializer)new LowerCasingEnumSerializer());
        this.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        this.registerModule((Module)module);
    }

    protected static class LowerCasingEnumSerializer
    extends StdSerializer<Enum> {
        private static final long serialVersionUID = 1L;

        public LowerCasingEnumSerializer() {
            super(Enum.class);
        }

        public void serialize(Enum value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.name().toLowerCase());
        }
    }
}

