/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.resource.filter;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.cache.annotation.CacheResult;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.cxf.jaxrs.impl.AbstractPropertiesImpl;
import org.ligoj.bootstrap.core.INamableBean;
import org.ligoj.bootstrap.core.NamedBean;
import org.ligoj.bootstrap.core.json.ObjectMapperTrim;
import org.ligoj.bootstrap.core.resource.AbstractMapper;
import org.ligoj.bootstrap.core.resource.filter.SystemHookParse;
import org.ligoj.bootstrap.dao.system.SystemHookRepository;
import org.ligoj.bootstrap.model.system.HookMatch;
import org.ligoj.bootstrap.resource.system.configuration.ConfigurationResource;
import org.ligoj.bootstrap.resource.system.hook.HookProcessRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Provider
public class HookResponseFilter
extends AbstractMapper
implements ContainerResponseFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HookResponseFilter.class);
    @Autowired
    protected SystemHookRepository repository;
    @Autowired
    private HookResponseFilter self = this;
    @Autowired
    private ObjectMapperTrim objectMapper;
    @Autowired
    private ConfigurationResource configurationResource;

    void execute(HookProcessRunnable runnable) {
        CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS).execute(runnable);
    }

    @CacheResult(cacheName="hooks")
    public Map<Pattern, List<SystemHookParse>> findAll() {
        Map<String, List<SystemHookParse>> patterns = this.repository.findAll().stream().map(h -> {
            SystemHookParse hp = new SystemHookParse();
            try {
                hp.setMatchObject((HookMatch)this.objectMapper.readValue(h.getMatch(), HookMatch.class));
                NamedBean.copy((INamableBean)h, (INamableBean)hp);
                hp.setCommand(h.getCommand());
                hp.setMatch(h.getMatch());
                hp.setWorkingDirectory(h.getWorkingDirectory());
                hp.setTimeout(h.getTimeout());
                hp.setInject(h.getInject());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return hp;
        }).filter(hp -> hp.getMatchObject() != null).filter(h -> {
            try {
                Pattern.compile(h.getMatchObject().getPath());
                return true;
            }
            catch (PatternSyntaxException e) {
                log.warn("Invalid path expression in hook {}", (Object)h.getName(), (Object)e);
                return false;
            }
        }).collect(Collectors.groupingBy(h -> h.getMatchObject().getPath()));
        return patterns.entrySet().stream().collect(Collectors.toMap(e -> Pattern.compile((String)e.getKey()), Map.Entry::getValue));
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        try {
            this.filterUnSafe(requestContext, responseContext);
        }
        catch (Exception e) {
            log.warn("Hook filtering failed. Partially or no triggered hooks", (Throwable)e);
        }
    }

    void filterUnSafe(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (responseContext.getStatus() >= 200 && responseContext.getStatus() < 300) {
            Map<Pattern, List<SystemHookParse>> hooksByPath = this.self.findAll();
            String path = requestContext.getUriInfo().getPath();
            List hooks = hooksByPath.entrySet().stream().filter(e -> ((Pattern)e.getKey()).matcher(path).matches()).flatMap(e -> ((List)e.getValue()).stream().filter(h -> h.getMatchObject().getMethod() == null || StringUtils.equalsIgnoreCase((CharSequence)h.getMatchObject().getMethod(), (CharSequence)requestContext.getMethod()))).toList();
            if (!hooks.isEmpty()) {
                String now = DateFormatUtils.formatUTC((Date)new Date(), (String)DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.getPattern());
                this.execute(new HookProcessRunnable(now, this.objectMapper, hooks, requestContext, responseContext, ((AbstractPropertiesImpl)requestContext).getMessage().getExchange(), requestContext.getSecurityContext().getUserPrincipal(), this.configurationResource));
            }
        }
    }
}

