/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.security;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.bootstrap.core.resource.mapper.AccessDeniedExceptionMapper;
import org.ligoj.bootstrap.core.security.RbacUserDetailsService;
import org.ligoj.bootstrap.model.system.SystemAuthorization;
import org.ligoj.bootstrap.resource.system.security.AuthorizationResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class AuthorizingFilter
extends GenericFilterBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthorizingFilter.class);
    @Autowired
    private AuthorizationResource authorizationResource;
    @Autowired
    private AccessDeniedExceptionMapper accessDeniedHelper;
    @Autowired
    private RbacUserDetailsService userDetailsService;
    private static final GrantedAuthority ROLE_ANONYMOUS = new SimpleGrantedAuthority("ROLE_ANONYMOUS");

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        Collection authorities = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
        if (!authorities.contains(ROLE_ANONYMOUS)) {
            String method;
            String fullRequest = this.getFullRequest(httpRequest);
            String viaUser = httpRequest.getHeader("x-api-via-user");
            if (viaUser != null) {
                if (this.isAuthorized(this.userDetailsService.loadUserByUsername(viaUser).getAuthorities(), "system/user", "POST")) {
                    log.info("Request for user {} via admin user {}", (Object)SecurityContextHolder.getContext().getAuthentication().getName(), (Object)viaUser);
                } else {
                    log.info("Invalid via-user {}, not ADMIN", (Object)viaUser);
                    this.updateForbiddenAccess((HttpServletResponse)response);
                    return;
                }
            }
            if (!this.isAuthorized(authorities, fullRequest, method = StringUtils.upperCase((String)httpRequest.getMethod()))) {
                this.updateForbiddenAccess((HttpServletResponse)response);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private void updateForbiddenAccess(HttpServletResponse response) throws IOException {
        Response response2 = this.accessDeniedHelper.toResponse(new AccessDeniedException(""));
        response.setStatus(response2.getStatus());
        response.setContentType(response2.getMediaType().toString());
        response.getOutputStream().write(((String)response2.getEntity()).getBytes(StandardCharsets.UTF_8));
    }

    private String getFullRequest(HttpServletRequest httpRequest) {
        return StringUtils.removeStart((String)httpRequest.getRequestURI().substring(this.getServletContext().getContextPath().length()), (String)"/");
    }

    private boolean isAuthorized(Collection<? extends GrantedAuthority> authorities, String request, String method) {
        Map<String, Map<String, List<Pattern>>> authorizationsCache = this.authorizationResource.getAuthorizations().get(SystemAuthorization.AuthorizationType.API);
        return authorizationsCache != null && authorities.stream().map(a -> (Map)authorizationsCache.get(a.getAuthority())).anyMatch(a -> a != null && this.match((Collection)a.get(method), request));
    }

    private boolean match(Collection<Pattern> patterns, String toMatch) {
        return patterns != null && patterns.stream().anyMatch(p -> p.matcher(toMatch).find());
    }

    @Generated
    public void setUserDetailsService(RbacUserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }
}

