/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.validation;

import com.thoughtworks.paranamer.AnnotationParanamer;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class JaxRsAnnotationParanamer
extends AnnotationParanamer {
    private static final Map<Class<? extends Annotation>, Function<Annotation, String>> ANNOTATION_NAME_PROVIDERS = new LinkedHashMap<Class<? extends Annotation>, Function<Annotation, String>>();

    protected String getNamedValue(Annotation ann) {
        String value = super.getNamedValue(ann);
        if (value == null && ANNOTATION_NAME_PROVIDERS.containsKey(ann.annotationType())) {
            return ANNOTATION_NAME_PROVIDERS.get(ann.annotationType()).apply(ann);
        }
        return value;
    }

    protected boolean isNamed(Annotation ann) {
        return super.isNamed(ann) || ANNOTATION_NAME_PROVIDERS.containsKey(ann.annotationType());
    }

    static {
        ANNOTATION_NAME_PROVIDERS.put(QueryParam.class, a -> ((QueryParam)a).value());
        ANNOTATION_NAME_PROVIDERS.put(HeaderParam.class, a -> ((HeaderParam)a).value());
        ANNOTATION_NAME_PROVIDERS.put(FormParam.class, a -> ((FormParam)a).value());
        ANNOTATION_NAME_PROVIDERS.put(CookieParam.class, a -> ((CookieParam)a).value());
        ANNOTATION_NAME_PROVIDERS.put(PathParam.class, a -> ((PathParam)a).value());
    }
}

