/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.api;

import jakarta.persistence.EntityNotFoundException;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.RandomStringGenerator;
import org.ligoj.bootstrap.core.NamedBean;
import org.ligoj.bootstrap.core.resource.OnNullReturn404;
import org.ligoj.bootstrap.core.security.SecurityHelper;
import org.ligoj.bootstrap.dao.system.SystemApiTokenRepository;
import org.ligoj.bootstrap.model.system.SystemApiToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Path(value="/api/token")
@Service
@Transactional
@Produces(value={"application/json"})
public class ApiTokenResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiTokenResource.class);
    private static final String PREFIX_TOKEN = "_plain_";
    private static final String PLAIN_HASH = "_plain_";
    private static final RandomStringGenerator GENERATOR = new RandomStringGenerator.Builder().filteredBy(new CharacterPredicate[]{c -> CharUtils.isAsciiAlphanumeric((char)Character.toChars(c)[0])}).get();
    @Autowired
    protected SystemApiTokenRepository repository;
    @Autowired
    private SecurityHelper securityHelper;
    @Value(value="${api.token.iterations:31}")
    private int tokenIterations;
    @Value(value="${api.token.digest:SHA-512}")
    private String tokenDigest;
    @Value(value="${api.token.length:128}")
    private int tokenLength;
    @Value(value="${api.token.crypt:DESede}")
    private String tokenCrypt;
    @Value(value="${api.token.secret:K%\u00eb\u00a3/L@_\u00a7z3-\u00c0\u00e7\u00f1?}")
    private String tokenSecret;

    public boolean check(String user, String token) {
        try {
            if (StringUtils.startsWith((CharSequence)token, (CharSequence)"_plain_")) {
                return this.repository.checkByUserAndToken(user, token);
            }
            return this.repository.checkByUserAndHash(user, this.hash(token));
        }
        catch (GeneralSecurityException e) {
            log.error("Unable to validate a token for user: {}", (Object)user, (Object)e);
            return false;
        }
    }

    @GET
    public List<String> getTokenNames() {
        return this.repository.findAllByUser(this.securityHelper.getLogin());
    }

    @GET
    @Path(value="{name:[\\w.-]+}")
    @OnNullReturn404
    @Produces(value={"text/plain"})
    public String getToken(@PathParam(value="name") String name) {
        SystemApiToken entity = this.repository.findByUserAndName(this.securityHelper.getLogin(), name);
        if (entity == null) {
            return null;
        }
        if (entity.getHash().equals("_plain_") && entity.getToken().startsWith("_plain_")) {
            return entity.getToken();
        }
        try {
            return this.decrypt(entity.getToken(), this.newSecretKey(entity.getUser(), entity.getName()));
        }
        catch (Exception e) {
            log.error("Unable to decrypt token {}", (Object)name, (Object)e);
            return null;
        }
    }

    public boolean hasToken(String user, String name) {
        return this.repository.findByUserAndName(user, name) != null;
    }

    private String decrypt(String encryptedMessage, byte[] secretKey) throws GeneralSecurityException {
        byte[] message = Base64.decodeBase64((byte[])encryptedMessage.getBytes(StandardCharsets.UTF_8));
        MessageDigest md = MessageDigest.getInstance(this.tokenDigest);
        byte[] digestOfPassword = md.digest(secretKey);
        byte[] keyBytes = Arrays.copyOf(digestOfPassword, 24);
        SecretKeySpec key = new SecretKeySpec(keyBytes, this.tokenCrypt);
        Cipher decipher = Cipher.getInstance(this.tokenCrypt);
        decipher.init(2, key);
        byte[] plainText = decipher.doFinal(message);
        return new String(plainText, StandardCharsets.UTF_8);
    }

    private String encrypt(String message, byte[] secretKey) throws GeneralSecurityException {
        MessageDigest digest = MessageDigest.getInstance(this.tokenDigest);
        digest.reset();
        byte[] digestOfPassword = digest.digest(secretKey);
        byte[] keyBytes = Arrays.copyOf(digestOfPassword, 24);
        SecretKeySpec key = new SecretKeySpec(keyBytes, this.tokenCrypt);
        Cipher cipher = Cipher.getInstance(this.tokenCrypt);
        cipher.init(1, key);
        byte[] plainTextBytes = message.getBytes(StandardCharsets.UTF_8);
        byte[] buf = cipher.doFinal(plainTextBytes);
        byte[] base64Bytes = Base64.encodeBase64((byte[])buf);
        return new String(base64Bytes, StandardCharsets.UTF_8);
    }

    private String hash(String token) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(this.tokenDigest);
        digest.reset();
        return Base64.encodeBase64String((byte[])digest.digest(token.getBytes(StandardCharsets.UTF_8)));
    }

    protected byte[] simpleHash(int iterations, String password) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.reset();
        byte[] input = digest.digest(password.getBytes(StandardCharsets.UTF_8));
        for (int i = 0; i < iterations; ++i) {
            digest.reset();
            input = digest.digest(input);
        }
        return input;
    }

    private byte[] newSecretKey(String login, String name) throws NoSuchAlgorithmException {
        return this.simpleHash(this.tokenIterations, login + this.tokenSecret + name);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="{name:[\\w.-]+}")
    public NamedBean<String> create(@PathParam(value="name") String name) throws GeneralSecurityException {
        return this.create(this.securityHelper.getLogin(), name);
    }

    public NamedBean<String> create(String user, String name) throws GeneralSecurityException {
        SystemApiToken entity = new SystemApiToken();
        entity.setName(name);
        entity.setUser(user);
        String token = this.newToken(entity);
        this.repository.saveAndFlush(entity);
        return new NamedBean((Serializable)((Object)token), name);
    }

    private String newToken(SystemApiToken entity) throws GeneralSecurityException {
        String token = this.newToken();
        entity.setHash(this.hash(token));
        entity.setToken(this.encrypt(token, this.newSecretKey(entity.getUser(), entity.getName())));
        return token;
    }

    private String newToken() {
        return GENERATOR.generate(this.tokenLength);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="{name:[\\w.-]+}")
    @Produces(value={"text/plain"})
    public String update(@PathParam(value="name") String name) throws GeneralSecurityException {
        SystemApiToken entity = this.repository.findByUserAndName(this.securityHelper.getLogin(), name);
        if (entity == null) {
            throw new EntityNotFoundException();
        }
        String token = this.newToken(entity);
        this.repository.saveAndFlush(entity);
        return token;
    }

    @DELETE
    @Path(value="{name:[\\w.-]+}")
    public void remove(@PathParam(value="name") String name) {
        this.repository.deleteByUserAndName(this.securityHelper.getLogin(), name);
    }

    public void removeAll(String login) {
        this.repository.deleteAllBy("user", login);
    }

    @Generated
    public void setTokenDigest(String tokenDigest) {
        this.tokenDigest = tokenDigest;
    }
}

