/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.cache;

import com.hazelcast.cache.HazelcastCacheManager;
import com.hazelcast.cache.impl.CacheProxy;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.internal.cluster.ClusterService;
import jakarta.persistence.EntityNotFoundException;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.ligoj.bootstrap.resource.system.cache.CacheCluster;
import org.ligoj.bootstrap.resource.system.cache.CacheNode;
import org.ligoj.bootstrap.resource.system.cache.CacheStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.jcache.JCacheCacheManager;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.stereotype.Service;

@Path(value="/system/cache")
@Service
@Transactional
@Produces(value={"application/json"})
public class CacheResource
implements ApplicationListener<ContextClosedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheResource.class);
    @Autowired
    protected CacheManager cacheManager;
    @Value(value="${hazelcast.statistics.enable:false}")
    private boolean statisticsEnabled = false;

    @GET
    public List<CacheStatistics> getCaches() {
        return this.cacheManager.getCacheNames().stream().map(this::getCache).toList();
    }

    @GET
    @Path(value="{name:[\\w\\-]+}")
    public CacheStatistics getCache(@PathParam(value="name") String name) {
        CacheStatistics result = new CacheStatistics();
        CacheProxy<Object, Object> cache = this.getCacheNative(name);
        CacheNode node = this.newCacheNode(cache.getNodeEngine().getLocalMember());
        node.setCluster(this.newCacheCluster(cache.getNodeEngine().getClusterService()));
        result.setId(name);
        result.setNode(node);
        this.setStatistics(result, cache.getLocalCacheStatistics());
        return result;
    }

    private CacheProxy<Object, Object> getCacheNative(String name) {
        return (CacheProxy)this.getCacheExpected(name).getNativeCache();
    }

    private Cache getCacheExpected(String name) {
        return Optional.ofNullable(this.cacheManager.getCache(name)).orElseThrow(() -> new EntityNotFoundException(name));
    }

    protected void setStatistics(CacheStatistics result, com.hazelcast.cache.CacheStatistics statistics) {
        result.setSize(statistics.getOwnedEntryCount());
        if (this.statisticsEnabled) {
            result.setMissPercentage(Float.valueOf(statistics.getCacheMissPercentage()));
            result.setMissCount(statistics.getCacheMisses());
            result.setHitPercentage(Float.valueOf(statistics.getCacheHitPercentage()));
            result.setHitCount(statistics.getCacheHits());
            result.setAverageGetTime(Float.valueOf(statistics.getAverageGetTime()));
        }
    }

    private CacheNode newCacheNode(Member member) {
        CacheNode node = new CacheNode();
        node.setAddress(Objects.toString(member.getAddress()));
        node.setId(member.getUuid().toString());
        node.setVersion(Objects.toString(member.getVersion()));
        return node;
    }

    private CacheCluster newCacheCluster(ClusterService clusterService) {
        CacheCluster cluster = new CacheCluster();
        cluster.setId(clusterService.getClusterId().toString());
        cluster.setState(clusterService.getClusterState().toString());
        cluster.setMembers(clusterService.getMembers().stream().map(this::newCacheNode).toList());
        return cluster;
    }

    @POST
    @DELETE
    @Path(value="{name:[\\w\\-]+}")
    public void invalidate(@PathParam(value="name") String name) {
        this.getCacheExpected(name).clear();
    }

    @POST
    @Path(value="statistics/enable")
    public void enableStatistics() {
        this.changeStatistics(true);
    }

    @POST
    @Path(value="statistics/disable")
    public void disableStatistics() {
        this.changeStatistics(false);
    }

    private void changeStatistics(boolean enabled) {
        ((ICacheService)this.getCacheNative("authorizations").getService()).getCacheConfigs().forEach(c -> c.setStatisticsEnabled(enabled));
        this.statisticsEnabled = enabled;
    }

    @DELETE
    public void invalidate() {
        this.cacheManager.getCacheNames().stream().map(arg_0 -> ((CacheManager)this.cacheManager).getCache(arg_0)).forEach(Cache::clear);
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        log.info("Stopping context detected, shutdown the Hazelcast instance");
        HazelcastCacheManager manager = (HazelcastCacheManager)((JCacheCacheManager)this.cacheManager).getCacheManager();
        try {
            manager.getHazelcastInstance().getLifecycleService().terminate();
        }
        catch (HazelcastInstanceNotActiveException he) {
            log.info("Hazelcast node was already terminated: {}", (Object)he.getMessage());
        }
    }

    @Generated
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }
}

