/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.resource.system.security;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.cache.annotation.CacheRemoveAll;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.dao.system.AuthorizationRepository;
import org.ligoj.bootstrap.dao.system.SystemRoleAssignmentRepository;
import org.ligoj.bootstrap.dao.system.SystemRoleRepository;
import org.ligoj.bootstrap.model.system.SystemAuthorization;
import org.ligoj.bootstrap.model.system.SystemRole;
import org.ligoj.bootstrap.resource.system.security.AuthorizationEditionVo;
import org.ligoj.bootstrap.resource.system.security.SystemRoleVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="/system/security/role")
@Service
@Transactional
@Produces(value={"application/json"})
public class RoleResource {
    private static final String ROLE_ID = "role.id";
    @Autowired
    private SystemRoleRepository repository;
    @Autowired
    private SystemRoleAssignmentRepository roleAssignmentRepository;
    @Autowired
    private AuthorizationRepository authorizationRepository;

    @GET
    @Path(value="name/{name}")
    @org.springframework.transaction.annotation.Transactional(readOnly=true)
    public SystemRole findByName(@PathParam(value="name") String name) {
        return (SystemRole)this.repository.findByExpected("name", name);
    }

    @GET
    @Path(value="{id:\\d+}")
    @org.springframework.transaction.annotation.Transactional(readOnly=true)
    public SystemRole findById(@PathParam(value="id") Integer id) {
        return (SystemRole)this.repository.findOneExpected(id);
    }

    @GET
    @org.springframework.transaction.annotation.Transactional(readOnly=true)
    public TableItem<SystemRole> findAll() {
        TableItem<SystemRole> result = new TableItem<SystemRole>();
        result.setData(this.repository.findAll());
        return result;
    }

    @GET
    @Path(value="withAuth")
    @org.springframework.transaction.annotation.Transactional(readOnly=true)
    public TableItem<SystemRoleVo> findAllFetchAuth() {
        TableItem<SystemRoleVo> result = new TableItem<SystemRoleVo>();
        TreeMap<Integer, SystemRoleVo> results = new TreeMap<Integer, SystemRoleVo>();
        this.fetchRoles(results);
        this.fetchAuthorizations(results);
        result.setData(new ArrayList(results.values()));
        result.setRecordsTotal(results.size());
        result.setRecordsTotal(results.size());
        return result;
    }

    private void fetchRoles(Map<Integer, SystemRoleVo> results) {
        List roles = this.repository.findAll();
        for (SystemRole role : roles) {
            SystemRoleVo roleVo = new SystemRoleVo();
            roleVo.setId((Integer)role.getId());
            roleVo.setName(role.getName());
            results.put((Integer)role.getId(), roleVo);
        }
    }

    private void fetchAuthorizations(Map<Integer, SystemRoleVo> results) {
        List auths = this.authorizationRepository.findAll();
        for (SystemAuthorization auth : auths) {
            AuthorizationEditionVo authVo = new AuthorizationEditionVo();
            results.get(auth.getRole().getId()).getAuthorizations().add(authVo);
            authVo.setId((Integer)auth.getId());
            authVo.setPattern(auth.getPattern());
            authVo.setType(auth.getType());
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @CacheRemoveAll(cacheName="authorizations")
    public int create(SystemRoleVo roleVo) {
        SystemRole role = new SystemRole();
        role.setName(roleVo.getName());
        Integer roleId = (Integer)((SystemRole)this.repository.saveAndFlush(role)).getId();
        for (AuthorizationEditionVo authVo : roleVo.getAuthorizations()) {
            SystemAuthorization auth = new SystemAuthorization();
            auth.setRole(role);
            auth.setPattern(authVo.getPattern());
            auth.setType(authVo.getType());
            this.authorizationRepository.save(auth);
        }
        return roleId;
    }

    @PUT
    @Consumes(value={"application/json"})
    @CacheRemoveAll(cacheName="authorizations")
    public void update(SystemRoleVo roleVo) {
        SystemRole role = (SystemRole)this.repository.findOneExpected((Integer)roleVo.getId());
        role.setName(roleVo.getName());
        for (SystemAuthorization auth : this.authorizationRepository.findAllBy(ROLE_ID, role.getId())) {
            if (!roleVo.getAuthorizations().stream().noneMatch(authVo -> ((Integer)auth.getId()).equals(authVo.getId()))) continue;
            this.authorizationRepository.delete(auth);
        }
        for (AuthorizationEditionVo authVo2 : roleVo.getAuthorizations()) {
            if (authVo2.getId() != null) continue;
            SystemAuthorization auth = new SystemAuthorization();
            auth.setRole(role);
            auth.setPattern(authVo2.getPattern());
            auth.setType(authVo2.getType());
            this.authorizationRepository.save(auth);
        }
        this.repository.save(role);
    }

    @DELETE
    @Path(value="{id:\\d+}")
    @CacheRemoveAll(cacheName="authorizations")
    public void remove(@PathParam(value="id") int id) {
        this.authorizationRepository.deleteAllBy(ROLE_ID, id);
        this.roleAssignmentRepository.deleteAllBy(ROLE_ID, id);
        this.repository.deleteById(id);
    }
}

