/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.curl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.ligoj.bootstrap.core.curl.CurlRequest;
import org.ligoj.bootstrap.core.curl.DefaultHttpResponseCallback;
import org.ligoj.bootstrap.core.curl.HttpResponseCallback;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurlProcessor
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CurlProcessor.class);
    public static final int DEFAULT_CONNECTION_TIMEOUT = 2000;
    public static final int DEFAULT_RESPONSE_TIMEOUT = 20000;
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String SSL_VERIFY = "ligoj.sslVerify";
    public static final DefaultHttpResponseCallback DEFAULT_CALLBACK = new DefaultHttpResponseCallback();
    private static final Map<String, Class<?>> SUPPORTED_METHOD = new HashMap();
    protected final CloseableHttpClient httpClient;
    protected final HttpClientBuilder clientBuilder;
    protected HttpResponseCallback callback;
    protected Function<CurlRequest, Boolean> replay;

    public static Registry<TlsSocketStrategy> newSslContext() {
        return CurlProcessor.newSslContext("TLS");
    }

    protected static Registry<TlsSocketStrategy> newSslContext(String protocol) {
        TrustManager[] allCerts = new TrustManager[]{new TrustedX509TrustManager()};
        try {
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(null, allCerts, new SecureRandom());
            DefaultClientTlsStrategy plainSocketFactory = new DefaultClientTlsStrategy(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            DefaultClientTlsStrategy sslSocketFactory = new DefaultClientTlsStrategy(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            return RegistryBuilder.create().register(URIScheme.HTTPS.id, (Object)sslSocketFactory).build();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Unable to build a secured " + protocol + " registry", e);
        }
    }

    public static void validateAndClose(String url, String propertyName, String errorText) {
        CurlProcessor.validateAndClose(url, propertyName, errorText, false, null, null);
    }

    public static void validateAndClose(String url, String propertyName, String errorText, boolean noVerifySsl, String proxyHost, Integer proxyPort) {
        try (CurlProcessor curlProcessor = new CurlProcessor(DEFAULT_CALLBACK, 2000L, 20000L, noVerifySsl, proxyHost, proxyPort);){
            curlProcessor.validate(url, propertyName, errorText);
        }
    }

    public CurlProcessor() {
        this(DEFAULT_CALLBACK);
    }

    public CurlProcessor(HttpResponseCallback callback) {
        this(callback, 2000L, 20000L);
    }

    public CurlProcessor(HttpResponseCallback callback, long connectionTimeout, long responseTimeout) {
        this(callback, connectionTimeout, responseTimeout, false, null, null);
    }

    public CurlProcessor(String proxyHost, Integer proxyPort) {
        this(DEFAULT_CALLBACK, 2000L, 20000L, false, proxyHost, proxyPort);
    }

    public CurlProcessor(HttpResponseCallback callback, long connectionTimeout, long responseTimeout, boolean noVerifySsl, String proxyHost, Integer proxyPort) {
        boolean verifySslResolved;
        this.callback = callback;
        this.clientBuilder = HttpClientBuilder.create();
        String proxyHostResolved = (String)StringUtils.defaultIfBlank((CharSequence)System.getProperty(HTTPS_PROXY_HOST), (CharSequence)proxyHost);
        if (proxyHostResolved != null) {
            String proxyPortResolved = ((Serializable)ObjectUtils.defaultIfNull((Object)proxyPort, (Object)((Serializable)((Object)StringUtils.defaultIfBlank((CharSequence)System.getProperty(HTTPS_PROXY_PORT), (CharSequence)"8080"))))).toString();
            HttpHost proxy = new HttpHost(proxyHostResolved, Integer.parseInt(proxyPortResolved));
            DefaultProxyRoutePlanner httpRoutePlanner = new DefaultProxyRoutePlanner(proxy);
            this.clientBuilder.setRoutePlanner((HttpRoutePlanner)httpRoutePlanner);
        }
        if (!(verifySslResolved = Boolean.parseBoolean((String)StringUtils.defaultIfBlank((CharSequence)System.getProperty(SSL_VERIFY), (CharSequence)String.valueOf(!noVerifySsl))))) {
            BasicHttpClientConnectionManager connectionManager = BasicHttpClientConnectionManager.create(CurlProcessor.newSslContext());
            this.clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
            this.clientBuilder.setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("relaxed").setRedirectsEnabled(false).setResponseTimeout(responseTimeout, TimeUnit.MILLISECONDS).setConnectionRequestTimeout(connectionTimeout, TimeUnit.MILLISECONDS).build());
        }
        BasicCookieStore cookieStore = new BasicCookieStore();
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore((CookieStore)cookieStore);
        this.clientBuilder.setDefaultCookieStore((CookieStore)cookieStore);
        this.httpClient = this.clientBuilder.disableRedirectHandling().build();
    }

    private void addHeaders(CurlRequest request, String content, HttpUriRequestBase httpRequest) {
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            httpRequest.setEntity((HttpEntity)new StringEntity(content, StandardCharsets.UTF_8));
            this.addSingleValuedHeader(request, httpRequest, "Content-Type", "application/x-www-form-urlencoded");
        }
        this.addSingleValuedHeader(request, httpRequest, "Accept-Charset", "utf-8");
        for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
            httpRequest.addHeader(header.getKey(), (Object)header.getValue());
        }
    }

    private void addSingleValuedHeader(CurlRequest request, HttpUriRequestBase httpRequest, String header, String defaultHeader) {
        if (request.getHeaders().keySet().stream().noneMatch(header::equalsIgnoreCase)) {
            httpRequest.addHeader(header, (Object)defaultHeader);
        }
    }

    protected boolean call(CurlRequest request, String url) throws Exception {
        final HttpUriRequestBase httpRequest = (HttpUriRequestBase)SUPPORTED_METHOD.get(request.getMethod()).getConstructor(String.class).newInstance(url);
        this.addHeaders(request, request.getContent(), httpRequest);
        if (request.getTimeout() != null) {
            TimerTask task = new TimerTask(this){

                @Override
                public void run() {
                    httpRequest.abort();
                }
            };
            new Timer(true).schedule(task, request.getTimeout().intValue());
        }
        return (Boolean)this.httpClient.execute((ClassicHttpRequest)httpRequest, response -> {
            request.setStatus(response.getCode());
            return ((HttpResponseCallback)ObjectUtils.defaultIfNull((Object)request.getCallback(), (Object)this.callback)).onResponse(request, response);
        });
    }

    @Override
    public void close() {
        try {
            this.getHttpClient().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String get(String url, String ... headers) {
        CurlRequest curlRequest = new CurlRequest("GET", url, null, headers);
        curlRequest.setSaveResponse(true);
        this.process(curlRequest);
        return curlRequest.getResponse();
    }

    public boolean process(CurlRequest ... requests) {
        int counter = 0;
        for (CurlRequest request : requests) {
            request.counter = counter++;
            if (this.process(request)) continue;
            return false;
        }
        return true;
    }

    protected boolean process(CurlRequest request) {
        String url = request.getUrl();
        request.processor = this;
        try {
            boolean result = this.call(request, url);
            if (!result && this.replay != null) {
                result = this.replay.apply(request) != false && this.call(request, url);
            }
            return result;
        }
        catch (Exception e) {
            log.error("Request execution ' [{}] {} {}' failed : {}", new Object[]{request.getCounter(), request.getMethod(), url, e.getMessage()});
            return false;
        }
    }

    public boolean process(List<CurlRequest> requests) {
        return this.process(requests.toArray(new CurlRequest[0]));
    }

    public void validate(CurlRequest request, String propertyName, String errorText) {
        if (!this.process(request)) {
            throw new ValidationJsonException(propertyName, (Serializable)((Object)errorText), new Serializable[0]);
        }
    }

    public void validate(String url, String propertyName, String errorText) {
        this.validate(new CurlRequest("GET", url, null, new String[0]), propertyName, errorText);
    }

    @Generated
    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public void setCallback(HttpResponseCallback callback) {
        this.callback = callback;
    }

    @Generated
    public void setReplay(Function<CurlRequest, Boolean> replay) {
        this.replay = replay;
    }

    static {
        SUPPORTED_METHOD.put("GET", HttpGet.class);
        SUPPORTED_METHOD.put("POST", HttpPost.class);
        SUPPORTED_METHOD.put("PUT", HttpPut.class);
        SUPPORTED_METHOD.put("DELETE", HttpDelete.class);
    }

    public static class TrustedX509TrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

