/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.IdentifiableType;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import jodd.typeconverter.TypeConverterManager;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.model.domain.internal.BasicSqmPathSource;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.spi.NavigablePath;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;

public abstract class AbstractSpecification {
    private static final TypeConverterManager CONVERTER = TypeConverterManager.get();
    public static final String DELIMITERS = "[_.]";
    private final AtomicInteger aliasCounter = new AtomicInteger();

    protected <U, T> Path<T> getOrmPath(Root<U> root, String path) {
        SqmPath currentPath = (SqmPath)root;
        for (String pathFragment : path.split(DELIMITERS)) {
            currentPath = this.getNextPath(pathFragment, (From)currentPath);
        }
        if (currentPath instanceof SqmJoin) {
            String idName = ((IdentifiableType)((Attribute)currentPath.getModel()).getDeclaringType()).getId(Object.class).getName();
            currentPath = this.getNextPath(idName, (From)currentPath);
        }
        return currentPath;
    }

    private <X> SqmPath<X> getNextPath(String pathFragment, From<?, ?> from) {
        SqmPath currentPath = (SqmPath)from.get(pathFragment);
        this.fixAlias((Selection)from, this.aliasCounter);
        if (!(currentPath.getReferencedPathSource() instanceof BasicSqmPathSource) && (currentPath = this.getPreviousJoinPath(from, currentPath.getNavigablePath().getLocalName())) == null) {
            currentPath = this.fixAlias((Selection)from.join(pathFragment, JoinType.LEFT), this.aliasCounter);
        }
        return currentPath;
    }

    protected <U, T> SqmPath<T> getPreviousJoinPath(From<?, U> from, String attribute) {
        for (Join join : from.getJoins()) {
            if (!join.getAttribute().getName().equals(attribute)) continue;
            return this.fixAlias((Selection<T>)join, this.aliasCounter);
        }
        for (Fetch fetch : from.getFetches()) {
            if (!fetch.getAttribute().getName().equals(attribute)) continue;
            return this.fixAlias((Selection)fetch, this.aliasCounter);
        }
        return null;
    }

    private <T> SqmPath<T> fixAlias(Selection<T> join, AtomicInteger integer) {
        if (join.getAlias() == null) {
            join.alias("_" + integer.incrementAndGet());
        }
        return (SqmPath)join;
    }

    protected static <Y> Y toRawData(EntityManager em, String data, Expression<Y> expression) {
        SessionFactoryImpl sf = (SessionFactoryImpl)((Session)em.unwrap(Session.class)).getSessionFactory();
        NavigablePath path = ((JpaPath)expression).getNavigablePath();
        MetamodelImplementor metaModel = sf.getMetamodel();
        NavigablePath parent = path;
        ArrayList<NavigablePath> reversePath = new ArrayList<NavigablePath>();
        do {
            reversePath.addFirst(parent);
        } while ((parent = parent.getParent()) != null);
        EntityMappingType model = metaModel.getEntityDescriptor(((NavigablePath)reversePath.getFirst()).getLocalName()).getEntityMappingType();
        for (int i = 1; i < reversePath.size() - 1; ++i) {
            String join = ((NavigablePath)reversePath.get(i)).getLocalName();
            boolean found = false;
            for (int j = 0; j < model.getNumberOfAttributeMappings(); ++j) {
                AttributeMapping mapping = model.getAttributeMapping(j);
                if (!join.equals(mapping.getFetchableName())) continue;
                if (mapping.isPluralAttributeMapping()) {
                    model = mapping.asPluralAttributeMapping().getCollectionDescriptor().getOwnerEntityPersister();
                    ++i;
                } else {
                    model = (EntityMappingType)mapping.getMappedType();
                }
                found = true;
                break;
            }
            if (found) continue;
            throw new ValidationJsonException("Invalid ORM path, cannot find '" + join + " in " + String.valueOf(model));
        }
        String field = path.getLocalName();
        Class expressionType = null;
        if (model.getIdentifierMapping().getAttributeName().equals(field)) {
            expressionType = model.getIdentifierMapping().getMappedType().getMappedJavaType().getJavaTypeClass();
        } else {
            for (int j = 0; j < model.getNumberOfAttributeMappings(); ++j) {
                AttributeMapping mapping = model.getAttributeMapping(j);
                if (!field.equals(mapping.getFetchableName())) continue;
                expressionType = mapping.getMappedType().getMappedJavaType().getJavaTypeClass();
                break;
            }
        }
        Object result = expressionType.isEnum() ? AbstractSpecification.toEnum(data, expression) : CONVERTER.convertType((Object)data, expressionType);
        return (Y)result;
    }

    private static <Y extends Enum<Y>> Enum<Y> toEnum(String data, Expression<Y> expression) {
        if (StringUtils.isNumeric((CharSequence)data)) {
            return ((Enum[])expression.getJavaType().getEnumConstants())[Integer.parseInt(data)];
        }
        Enum fromName = EnumUtils.getEnum((Class)expression.getJavaType(), (String)data);
        if (fromName == null) {
            fromName = Enum.valueOf(expression.getJavaType(), data.toUpperCase(Locale.ENGLISH));
        }
        return fromName;
    }
}

