/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.dao;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.boot.archive.scan.internal.StandardScanner;
import org.hibernate.boot.archive.scan.spi.ScanEnvironment;
import org.hibernate.boot.archive.scan.spi.ScanOptions;
import org.hibernate.boot.archive.scan.spi.ScanParameters;
import org.hibernate.boot.archive.scan.spi.ScanResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceScanner
extends StandardScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceScanner.class);
    public static final String META_INF_ORM_XML = "META-INF/orm.xml";

    public ScanResult scan(ScanEnvironment environment, ScanOptions scanOptions, ScanParameters parameters) {
        try {
            LinkedHashSet<URL> urls = new LinkedHashSet<URL>(environment.getNonRootUrls());
            urls.addAll(Collections.list(this.getOrmUrls()).stream().map(this::getJarUrlSafe).toList());
            urls.remove(environment.getRootUrl());
            environment.getNonRootUrls().clear();
            environment.getNonRootUrls().addAll(urls);
            return super.scan(environment, scanOptions, parameters);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read ORM Jars", e);
        }
    }

    private URL getJarUrlSafe(URL ormUrl) {
        try {
            return this.getJarUrl(ormUrl);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read ORM file from jar", e);
        }
    }

    protected URL getJarUrl(URL ormUrl) throws MalformedURLException, URISyntaxException {
        URI ormJarUrl;
        String urlStr = ormUrl.toString();
        if ("jar".equals(ormUrl.getProtocol())) {
            if (StringUtils.countMatches((CharSequence)ormUrl.getPath(), (CharSequence)"!") > 1) {
                log.info("Hibernate ORM, remove nested part from path {}", (Object)ormUrl);
                ormJarUrl = URI.create(StringUtils.substringBeforeLast((String)urlStr, (String)"!"));
            } else {
                log.info("Hibernate ORM, remove nested part from file URL from {}", (Object)ormUrl);
                ormJarUrl = new URI("file", ormUrl.getHost(), ormUrl.getPath().substring("file:".length(), ormUrl.getPath().indexOf(33)), null);
            }
        } else {
            log.info("Hibernate ORM, remove trailing /orm.xml from {}", (Object)ormUrl);
            ormJarUrl = URI.create(urlStr.substring(0, urlStr.length() - META_INF_ORM_XML.length() - 1));
        }
        return ormJarUrl.toURL();
    }

    protected Enumeration<URL> getOrmUrls() throws IOException {
        return Thread.currentThread().getContextClassLoader().getResources(META_INF_ORM_XML);
    }
}

