/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.resource.filter;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.util.List;
import org.ligoj.bootstrap.core.resource.AbstractMapper;
import org.ligoj.bootstrap.core.resource.OnNullReturn404;
import org.ligoj.bootstrap.core.resource.ServerError;

@Provider
public class NotFoundResponseFilter
extends AbstractMapper
implements ContainerResponseFilter {
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (responseContext.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
            for (Annotation annotation : responseContext.getEntityAnnotations()) {
                if (annotation.annotationType() != OnNullReturn404.class) continue;
                this.replaceResponse(requestContext, responseContext);
                return;
            }
        }
    }

    private void replaceResponse(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        ServerError serverError = new ServerError();
        if (requestContext.getUriInfo().getPathParameters().size() == 1) {
            serverError.setCode("entity");
            serverError.setMessage((String)((List)requestContext.getUriInfo().getPathParameters().values().iterator().next()).getFirst());
        } else {
            serverError.setCode("data");
        }
        responseContext.setStatus(Response.Status.NOT_FOUND.getStatusCode());
        responseContext.setEntity(this.toEntity(serverError), responseContext.getEntityAnnotations(), MediaType.APPLICATION_JSON_TYPE);
    }
}

