/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.resource.mapper;

import jakarta.validation.ConstraintViolationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.ligoj.bootstrap.core.resource.AbstractMapper;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionSystemException;

@Provider
public class TransactionSystemExceptionMapper
extends AbstractMapper
implements ExceptionMapper<TransactionSystemException> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransactionSystemExceptionMapper.class);

    public Response toResponse(TransactionSystemException ex) {
        Throwable throwable = ExceptionUtils.getRootCause((Throwable)ex);
        if (throwable instanceof ConstraintViolationException) {
            ConstraintViolationException c = (ConstraintViolationException)throwable;
            return this.toResponse((Response.StatusType)Response.Status.BAD_REQUEST, (Throwable)new ValidationJsonException(c));
        }
        log.error("Technical exception", (Throwable)ex);
        return this.toResponse((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "technical", (Throwable)ex);
    }
}

