/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.core.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheResult;
import org.ligoj.bootstrap.core.DateUtils;
import org.ligoj.bootstrap.dao.system.SystemUserRepository;
import org.ligoj.bootstrap.model.system.SystemRole;
import org.ligoj.bootstrap.model.system.SystemUser;
import org.ligoj.bootstrap.resource.system.session.ISessionSettingsProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Component;

@Component
public class RbacUserDetailsService
implements UserDetailsService {
    @Autowired
    private SystemUserRepository userRepository;
    @Autowired
    protected ApplicationContext applicationContext;

    @CacheResult(cacheName="user-details")
    public UserDetails loadUserByUsername(@CacheKey String username) {
        Collection<Object> authorities;
        SystemUser user;
        Object[][] userAndRoles = this.userRepository.findByLoginFetchRoles(username);
        if (userAndRoles.length == 0) {
            user = new SystemUser();
            user.setLogin(username);
            authorities = new ArrayList();
        } else {
            user = (SystemUser)userAndRoles[0][0];
            authorities = this.toSimpleRoles(userAndRoles, 1);
        }
        Date now = DateUtils.newCalendar().getTime();
        if (user.getLastConnection() == null || now.getTime() - user.getLastConnection().getTime() > 86400000L) {
            user.setLastConnection(now);
            this.userRepository.saveAndFlush(user);
        }
        authorities.add(new SimpleGrantedAuthority("USER"));
        this.applicationContext.getBeansOfType(ISessionSettingsProvider.class).values().forEach(p -> authorities.addAll(p.getGrantedAuthorities(username)));
        return new User(username, "N/A", authorities);
    }

    private Set<GrantedAuthority> toSimpleRoles(Object[][] results, int index) {
        HashSet<GrantedAuthority> result = new HashSet<GrantedAuthority>();
        HashSet<String> resultAsName = new HashSet<String>();
        for (Object[] object : results) {
            SystemRole role = (SystemRole)object[index];
            if (role == null || !resultAsName.add(role.getName())) continue;
            result.add((GrantedAuthority)new SimpleGrantedAuthority(role.getAuthority()));
        }
        return result;
    }
}

